/*
 * Decompiled with CFR 0.152.
 */
package cech12.ceramicbucket.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public static final int DEFAULT_CERAMIC_BUCKET_BREAK_TEMPERATURE = 1000;
    public static ForgeConfigSpec SERVER_CONFIG;
    public static final ForgeConfigSpec.IntValue CERAMIC_BUCKET_BREAK_TEMPERATURE;
    public static final ForgeConfigSpec.BooleanValue MILKING_ENABLED;
    public static final ForgeConfigSpec.BooleanValue FISH_OBTAINING_ENABLED;
    public static final ForgeConfigSpec.IntValue CERAMIC_BUCKET_DURABILITY;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Balance Options");
        CERAMIC_BUCKET_BREAK_TEMPERATURE = builder.comment("Minimum temperature of fluid at which the Ceramic Bucket breaks when emptied. (-1 means that bucket never breaks caused by high fluid temperature)").defineInRange("ceramicBucketBreakTemperature", 1000, -1, 10000);
        MILKING_ENABLED = builder.comment("Whether or not milking entities with a Ceramic Bucket should be enabled.").define("milkingEnabled", true);
        FISH_OBTAINING_ENABLED = builder.comment("Whether or not obtaining fish with a Ceramic Bucket should be enabled.").define("fishObtainingEnabled", true);
        CERAMIC_BUCKET_DURABILITY = builder.comment("Defines the maximum durability of a Ceramic Bucket. (0 deactivates the durability)").defineInRange("durability", 0, 0, 10000);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

