/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.renderer.entity.mob.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.ad_astra.common.entity.mob.CorruptedLunarian;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CorruptedLunarianModel
extends EntityModel<CorruptedLunarian> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("ad_astra", "corrupted_lunarian"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart arm1;
    private final ModelPart arm2;
    private final ModelPart monsterarm1;
    private final ModelPart monsterarm2;
    private final ModelPart monsterarm3;
    private final ModelPart monsterarm4;

    public CorruptedLunarianModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.leg0 = root.m_171324_("leg0");
        this.leg1 = root.m_171324_("leg1");
        this.arm1 = root.m_171324_("arms").m_171324_("arm1");
        this.arm2 = root.m_171324_("arms").m_171324_("arm2");
        this.monsterarm1 = root.m_171324_("extra_arms").m_171324_("backarm1");
        this.monsterarm2 = root.m_171324_("extra_arms").m_171324_("backarm2");
        this.monsterarm3 = root.m_171324_("extra_arms").m_171324_("backarm3");
        this.monsterarm4 = root.m_171324_("extra_arms").m_171324_("backarm4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171480_().m_171488_(-4.0f, -9.0f, -4.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171480_().m_171488_(-4.5f, -18.0f, -4.5f, 9.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 20).m_171480_().m_171488_(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition extra_arms = partdefinition.m_171599_("extra_arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition backarm1 = extra_arms.m_171599_("backarm1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.2968f, (float)6.4078f, (float)0.3907f));
        PartDefinition body_r1 = backarm1.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171488_(-11.5f, 0.0f, 9.5f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(36, 0).m_171488_(-1.5f, 0.0f, -0.5f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.2968f, (float)-0.4078f, (float)0.1093f, (float)-0.6109f, (float)-0.6109f, (float)0.0f));
        PartDefinition backarm2 = extra_arms.m_171599_("backarm2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)6.0f, (float)1.0f));
        PartDefinition body_r2 = backarm2.m_171599_("body_r2", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171480_().m_171488_(2.0f, 0.0f, 9.5f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(36, 0).m_171488_(0.0f, 0.0f, -0.5f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)-0.5f, (float)-0.6109f, (float)0.6981f, (float)0.0f));
        PartDefinition backarm3 = extra_arms.m_171599_("backarm3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)4.0f, (float)1.0f));
        PartDefinition body_r3 = backarm3.m_171599_("body_r3", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171488_(-11.5f, -2.0f, 9.5f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(36, 0).m_171488_(-1.5f, -2.0f, -0.5f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-0.5f, (float)0.6109f, (float)-0.6109f, (float)0.0f));
        PartDefinition backarm4 = extra_arms.m_171599_("backarm4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)4.0f, (float)0.0f));
        PartDefinition body_r4 = backarm4.m_171599_("body_r4", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171480_().m_171488_(2.0f, -2.0f, 9.5f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(36, 0).m_171488_(0.0f, -2.0f, -0.5f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)1.0f, (float)0.5f, (float)0.6109f, (float)0.6109f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171480_().m_171488_(0.0f, -12.0f, -5.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 36).m_171480_().m_171488_(0.0f, -12.0f, -5.0f, 8.0f, 19.0f, 6.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)12.0f, (float)2.0f));
        PartDefinition leg0 = partdefinition.m_171599_("leg0", CubeListBuilder.m_171558_().m_171514_(0, 81).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition leg1 = partdefinition.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(0, 81).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition arms = partdefinition.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition arm1 = arms.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(30, 61).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)0.1434f, (float)0.2048f));
        PartDefinition arm2 = arms.m_171599_("arm2", CubeListBuilder.m_171558_().m_171514_(30, 61).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)0.1434f, (float)0.2048f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(CorruptedLunarian entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.arm2.f_104204_ = 0.0f;
        this.arm1.f_104204_ = 0.0f;
        this.arm2.f_104205_ = 0.0f;
        this.arm1.f_104205_ = 0.0f;
        this.arm2.f_104203_ = 0.0f;
        this.arm1.f_104203_ = 0.0f;
        this.arm2.f_104205_ -= Mth.m_14089_((float)(animationProgress * 0.04f)) * 0.04f + 0.04f;
        this.arm1.f_104205_ += Mth.m_14089_((float)(animationProgress * 0.04f)) * 0.04f + 0.04f;
        this.head.f_104204_ = headYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.leg0.f_104203_ = Mth.m_14089_((float)limbAngle) * -1.0f * limbDistance;
        this.leg1.f_104203_ = Mth.m_14089_((float)limbAngle) * 1.0f * limbDistance;
        this.monsterarm1.f_104204_ = Mth.m_14089_((float)(limbAngle * 0.3662f + (float)Math.PI)) * limbDistance / 2.0f;
        this.monsterarm4.f_104204_ = Mth.m_14089_((float)(limbAngle * 0.3662f + (float)Math.PI)) * limbDistance / 2.0f;
        this.monsterarm3.f_104204_ = Mth.m_14089_((float)(limbAngle * 0.3662f + (float)Math.PI)) * limbDistance / 2.0f;
        this.monsterarm2.f_104204_ = Mth.m_14089_((float)(limbAngle * 0.3662f + (float)Math.PI)) * limbDistance / 2.0f;
        this.arm1.f_104203_ = 30.0f;
        this.arm2.f_104203_ = 30.0f;
        this.arm2.f_104203_ -= Mth.m_14089_((float)(animationProgress * 0.04f)) * 0.04f + 0.04f;
        this.arm1.f_104203_ += Mth.m_14089_((float)(animationProgress * 0.04f)) * 0.04f + 0.04f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertices, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104301_(poseStack, vertices, packedLight, packedOverlay);
        this.body.m_104301_(poseStack, vertices, packedLight, packedOverlay);
        this.leg0.m_104301_(poseStack, vertices, packedLight, packedOverlay);
        this.leg1.m_104301_(poseStack, vertices, packedLight, packedOverlay);
        this.arm1.m_104301_(poseStack, vertices, packedLight, packedOverlay);
        this.arm2.m_104301_(poseStack, vertices, packedLight, packedOverlay);
        this.monsterarm1.m_104301_(poseStack, vertices, packedLight, packedOverlay);
        this.monsterarm2.m_104301_(poseStack, vertices, packedLight, packedOverlay);
        this.monsterarm3.m_104301_(poseStack, vertices, packedLight, packedOverlay);
        this.monsterarm4.m_104301_(poseStack, vertices, packedLight, packedOverlay);
    }
}

