/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.pipe;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface InteractablePipe<T> {
    public boolean supportsAutoExtract();

    public boolean canConnectTo(BlockEntity var1, Direction var2, BlockPos var3);

    public void insertInto(T var1, Direction var2, BlockPos var3);

    public T getInteraction(Level var1, BlockPos var2, Direction var3);

    public Node<T> getSource();

    public void setSource(Node<T> var1);

    public void clearSource();

    public List<Node<T>> getConsumers();

    public Level getPipelevel();

    public BlockPos getPipePos();

    public int getWorkTime();

    public long getTransferAmount();

    default public void handleSourceFinding() {
    }

    /*
     * WARNING - void declaration
     */
    default public void pipeTick() {
        block11: {
            block12: {
                if (this.getPipelevel().m_5776_()) break block11;
                if (this.getPipelevel().m_46467_() % (long)this.getWorkTime() != 0L) break block12;
                this.clearSource();
                this.getConsumers().clear();
                HashSet<BlockPos> visitedNodes = new HashSet<BlockPos>();
                HashSet<Object> availableNodes = new HashSet<Object>();
                if (this.supportsAutoExtract()) {
                    void var5_9;
                    availableNodes.add(this.getPipePos());
                    Direction[] directionArray = Direction.values();
                    int n = directionArray.length;
                    boolean bl = false;
                    while (var5_9 < n) {
                        Direction direction = directionArray[var5_9];
                        BlockPos offset = this.getPipePos().m_121945_(direction);
                        T potentialSource = this.getInteraction(this.getPipelevel(), offset, direction);
                        if (potentialSource != null) {
                            this.setSource(new Node<T>(potentialSource, direction, offset));
                            break;
                        }
                        ++var5_9;
                    }
                } else {
                    this.handleSourceFinding();
                }
                if (this.getSource() == null) break block11;
                while (!availableNodes.isEmpty()) {
                    ArrayList<BlockPos> temporaryOpenNodes = new ArrayList<BlockPos>();
                    for (BlockPos blockPos : availableNodes) {
                        BlockEntity current = this.getPipelevel().m_7702_(blockPos);
                        for (Direction direction : Direction.values()) {
                            BlockPos offset = blockPos.m_121945_(direction);
                            BlockEntity entity = this.getPipelevel().m_7702_(offset);
                            if (!visitedNodes.contains(offset) && entity instanceof InteractablePipe) {
                                InteractablePipe pipe = (InteractablePipe)entity;
                                if (!pipe.canConnectTo(current, direction, offset)) continue;
                                temporaryOpenNodes.add(offset);
                                continue;
                            }
                            T potentialConsumer = this.getInteraction(this.getPipelevel(), offset, direction);
                            if (potentialConsumer == null) continue;
                            this.getConsumers().add(new Node<T>(potentialConsumer, direction, blockPos));
                        }
                        visitedNodes.add(blockPos);
                    }
                    availableNodes.clear();
                    availableNodes.addAll(temporaryOpenNodes);
                }
                break block11;
            }
            if (this.getSource() != null && !this.getConsumers().isEmpty()) {
                for (Node<T> consumer : this.getConsumers()) {
                    this.insertInto(consumer.storage(), consumer.direction(), consumer.pos());
                }
            }
        }
    }

    public record Node<T>(T storage, Direction direction, BlockPos pos) {
    }
}

