/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity.mob;

import earth.terrarium.ad_astra.common.entity.mob.goal.EatPermafrostGoal;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import earth.terrarium.ad_astra.common.registry.ModEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class GlacianRam
extends Animal
implements Shearable {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(GlacianRam.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int eatPermafrostTimer;
    private EatPermafrostGoal eatPermafrostGoal;

    public GlacianRam(EntityType<? extends GlacianRam> entityType, Level level) {
        super(entityType, level);
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    protected void m_8099_() {
        this.eatPermafrostGoal = new EatPermafrostGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ICE_SHARD.get()}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)this.eatPermafrostGoal);
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.ICE_SHARD.get());
    }

    public void m_8035_() {
        this.setSheared(false);
        if (this.m_6162_()) {
            this.m_146758_(60);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42446_) && !this.m_6162_()) {
            player.m_5496_(this.getMilkingSound(), 1.0f, 1.0f);
            ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42455_.m_7968_());
            player.m_21008_(hand, itemStack2);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        InteractionResult actionResult = super.m_6071_(player, hand);
        if (actionResult.m_19077_() && this.m_6898_(itemStack)) {
            this.f_19853_.m_6269_(null, (Entity)this, this.m_7866_(itemStack), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.f_19853_.f_46441_, (float)0.8f, (float)1.2f));
        }
        return this.shear(player, hand);
    }

    protected void m_8024_() {
        this.eatPermafrostTimer = this.eatPermafrostGoal.getTimer();
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            this.eatPermafrostTimer = Math.max(0, this.eatPermafrostTimer - 1);
        }
        super.m_8107_();
    }

    public InteractionResult shear(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42574_)) {
            if (!this.f_19853_.f_46443_ && this.m_6220_()) {
                this.shear(player, SoundSource.PLAYERS);
                itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public void m_5851_(SoundSource shearedSoundCategory) {
        this.shear(null, shearedSoundCategory);
    }

    public void shear(@Nullable Player player, SoundSource shearedSoundCategory) {
        for (ItemStack item : this.onSheared(player, shearedSoundCategory)) {
            ItemEntity itemEntity = this.m_19983_(item);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public List<ItemStack> onSheared(@Nullable Player player, SoundSource shearedSoundCategory) {
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12344_, shearedSoundCategory, 1.0f, 1.0f);
        if (player != null) {
            this.m_146852_(GameEvent.f_157781_, (Entity)player);
        }
        this.setSheared(true);
        int i = 1 + this.f_19796_.m_188503_(3);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            items.add(new ItemStack((ItemLike)ModBlocks.GLACIAN_FUR.get()));
        }
        return items;
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("Sheared", this.isSheared());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setSheared(nbt.m_128471_("Sheared"));
    }

    public GlacianRam getBreedOffspring(ServerLevel serverWorld, AgeableMob passiveEntity) {
        return (GlacianRam)((EntityType)ModEntityTypes.GLACIAN_RAM.get()).m_20615_((Level)serverWorld);
    }

    public SoundEvent m_7866_(ItemStack stack) {
        return SoundEvents.f_144165_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_144163_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_144166_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_144164_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_144151_, 0.15f, 1.0f);
    }

    public SoundEvent getMilkingSound() {
        return SoundEvents.f_144168_;
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean shear) {
        this.f_19804_.m_135381_(SHEARED, (Object)shear);
    }

    public void m_7822_(byte status) {
        if (status == 10) {
            this.eatPermafrostTimer = 40;
        } else {
            super.m_7822_(status);
        }
    }

    public float getNeckAngle(float delta) {
        if (this.eatPermafrostTimer <= 0) {
            return 0.0f;
        }
        if (this.eatPermafrostTimer >= 4 && this.eatPermafrostTimer <= 36) {
            return 1.0f;
        }
        return this.eatPermafrostTimer < 4 ? ((float)this.eatPermafrostTimer - delta) / 4.0f : -((float)(this.eatPermafrostTimer - 40) - delta) / 4.0f;
    }

    public float getHeadAngle(float delta) {
        if (this.eatPermafrostTimer > 4 && this.eatPermafrostTimer <= 36) {
            float f = ((float)(this.eatPermafrostTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        return this.eatPermafrostTimer > 0 ? 0.62831855f : this.m_146909_() * ((float)Math.PI / 180);
    }
}

