/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity.system;

import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.item.armor.NetheriteSpaceSuit;
import earth.terrarium.ad_astra.common.item.armor.SpaceSuit;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Range;

public class EntityTemperatureSystem {
    public static final Range<Integer> TEMP_RANGE = Range.between((Comparable)Integer.valueOf(-60), (Comparable)Integer.valueOf(70));

    public static void temperatureTick(LivingEntity entity, ServerLevel level) {
        if (!AdAstraConfig.doOxygen) {
            return;
        }
        if (!entity.m_6095_().equals(EntityType.f_20524_)) {
            if (entity.m_21222_()) {
                return;
            }
            if (ModUtils.checkTag((Entity)entity, ModTags.LIVES_WITHOUT_OXYGEN)) {
                return;
            }
        }
        float temperature = ModUtils.getWorldTemperature((Level)level);
        if (OxygenUtils.inDistributorBubble((Level)level, entity.m_20183_())) {
            temperature = 20.0f;
        }
        Range<Integer> temperatureResistance = TEMP_RANGE;
        if (SpaceSuit.hasFullSet(entity)) {
            temperatureResistance = ((SpaceSuit)((ItemStack)entity.m_6168_().iterator().next()).m_41720_()).getTemperatureThreshold();
        }
        if (!(!(temperature > (float)((Integer)temperatureResistance.getMaximum()).intValue()) || entity.m_5825_() || entity.m_21023_(MobEffects.f_19607_) || NetheriteSpaceSuit.hasFullSet(entity) || ModUtils.armourIsHeatResistant(entity))) {
            EntityTemperatureSystem.burnEntity(entity);
        } else if (temperature < (float)((Integer)temperatureResistance.getMinimum()).intValue() && !ModUtils.armourIsFreezeResistant(entity)) {
            EntityTemperatureSystem.freezeEntity(entity, level);
        }
    }

    private static void burnEntity(LivingEntity entity) {
        entity.m_6469_(DamageSource.f_19307_, (float)AdAstraConfig.heatDamage);
        entity.m_20254_(10);
    }

    private static void freezeEntity(LivingEntity entity, ServerLevel level) {
        entity.m_6469_(DamageSource.f_146701_, (float)AdAstraConfig.freezeDamage);
        entity.m_146917_(Math.min(entity.m_146891_() + 20, entity.m_146888_() + 50));
        RandomSource random = entity.f_19853_.m_213780_();
        ModUtils.spawnForcedParticles(level, ParticleTypes.f_175821_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 1, Mth.m_216283_((RandomSource)random, (float)-1.0f, (float)1.0f) * 0.083333336f, 0.05, (double)Mth.m_216283_((RandomSource)random, (float)-1.0f, (float)1.0f) * 0.083333336, 0.0);
        if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            skeleton.m_21406_(EntityType.f_20481_, true);
        }
    }
}

