/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import earth.terrarium.ad_astra.common.recipe.ModRecipe;
import earth.terrarium.ad_astra.common.recipe.condition.IRecipeCondition;
import earth.terrarium.ad_astra.common.recipe.condition.IRecipeConditionSerializer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;

public abstract class ModRecipeBuilder<RECIPE extends ModRecipe> {
    private final List<IRecipeCondition> conditions = new ArrayList<IRecipeCondition>();

    public void addCondition(IRecipeCondition condition) {
        this.conditions.add(condition);
    }

    public static abstract class ModFinishedRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final List<IRecipeCondition> conditions;

        public ModFinishedRecipe(ModRecipeBuilder<?> builder, ResourceLocation id) {
            this.id = id;
            this.conditions = new ArrayList<IRecipeCondition>(builder.conditions);
        }

        public void m_7917_(JsonObject json) {
            if (!this.conditions.isEmpty()) {
                JsonArray fabricConditionArray = new JsonArray();
                JsonArray forgeConditionArray = new JsonArray();
                for (IRecipeCondition recipeCondition : this.conditions) {
                    fabricConditionArray.add((JsonElement)IRecipeConditionSerializer.serializeFabricCondition(recipeCondition));
                    forgeConditionArray.add((JsonElement)IRecipeConditionSerializer.serializeForgeCondition(recipeCondition));
                }
                json.add("fabric:load_conditions", (JsonElement)fabricConditionArray);
                json.add("conditions", (JsonElement)forgeConditionArray);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

