/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.recipe.lunarian;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.codecs.recipes.ItemStackCodec;
import earth.terrarium.ad_astra.common.recipe.ModRecipe;
import earth.terrarium.ad_astra.common.recipe.ModRecipeBuilder;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public abstract class LunarianTradeRecipe
extends ModRecipe {
    private boolean wandering;
    private VillagerProfession profession;
    private int level;
    private ItemStack buyA;
    private ItemStack buyB;
    private ItemStack sell;
    private int maxUses;
    private int experience;
    private float multiplier;

    protected LunarianTradeRecipe(ResourceLocation id) {
        super(id);
    }

    protected LunarianTradeRecipe(ResourceLocation id, Builder<? extends LunarianTradeRecipe> builder) {
        super(id);
        this.wandering = builder.wandering;
        this.profession = builder.profession;
        this.level = builder.level;
        this.buyA = builder.buyA;
        this.buyB = builder.buyB;
        this.sell = builder.sell;
        this.maxUses = builder.maxUses;
        this.experience = builder.experience;
        this.multiplier = builder.multiplier;
    }

    protected void fromJson(JsonObject json) {
        this.wandering = GsonHelper.m_13855_((JsonObject)json, (String)"wandering", (boolean)false);
        this.profession = (VillagerProfession)Registry.f_122869_.m_7745_(ResourceLocation.m_135820_((String)GsonHelper.m_13851_((JsonObject)json, (String)"profession", (String)"")));
        this.level = GsonHelper.m_13927_((JsonObject)json, (String)"level");
        this.buyA = ItemStackCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("buyA")).result().orElse(this.getDefaultBuyA());
        this.buyB = ItemStackCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("buyB")).result().orElse(this.getDefaultBuyB());
        this.sell = ItemStackCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("sell")).result().orElse(this.getDefaultSell());
        this.maxUses = GsonHelper.m_13824_((JsonObject)json, (String)"maxUses", (int)this.getDefaultMaxUses());
        this.experience = GsonHelper.m_13824_((JsonObject)json, (String)"experience", (int)this.getDefaultExperience());
        this.multiplier = GsonHelper.m_13820_((JsonObject)json, (String)"multiplier", (float)this.getDefaultMultiplier());
    }

    protected void toJson(JsonObject json) {
        if (this.wandering) {
            json.addProperty("wandering", Boolean.valueOf(this.wandering));
        } else {
            json.addProperty("profession", Registry.f_122869_.m_7981_((Object)this.profession).toString());
        }
        json.addProperty("level", (Number)this.level);
        if (!this.buyA.m_41619_()) {
            json.add("buyA", (JsonElement)ItemStackCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.buyA).result().get());
        }
        if (!this.buyB.m_41619_()) {
            json.add("buyB", (JsonElement)ItemStackCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.buyB).result().get());
        }
        if (!this.sell.m_41619_()) {
            json.add("sell", (JsonElement)ItemStackCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.sell).result().get());
        }
        if (this.maxUses != this.getDefaultMaxUses()) {
            json.addProperty("maxUses", (Number)this.maxUses);
        }
        if (this.experience != this.getDefaultExperience()) {
            json.addProperty("experience", (Number)this.experience);
        }
        if (this.multiplier != this.getDefaultMultiplier()) {
            json.addProperty("multiplier", (Number)Float.valueOf(this.multiplier));
        }
    }

    protected ItemStack getDefaultBuyA() {
        return ItemStack.f_41583_;
    }

    protected ItemStack getDefaultBuyB() {
        return ItemStack.f_41583_;
    }

    protected ItemStack getDefaultSell() {
        return ItemStack.f_41583_;
    }

    protected int getDefaultMaxUses() {
        return 12;
    }

    protected int getDefaultExperience() {
        return 0;
    }

    protected float getDefaultMultiplier() {
        return 0.05f;
    }

    protected void fromNetwork(FriendlyByteBuf buffer) {
        this.wandering = buffer.readBoolean();
        this.profession = (VillagerProfession)Registry.f_122869_.m_7745_(buffer.m_130281_());
        this.level = buffer.readInt();
        this.buyA = buffer.m_130267_();
        this.buyB = buffer.m_130267_();
        this.sell = buffer.m_130267_();
        this.maxUses = buffer.readInt();
        this.experience = buffer.readInt();
        this.multiplier = buffer.readFloat();
    }

    protected void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.wandering);
        buffer.m_130085_(Registry.f_122869_.m_7981_((Object)this.profession));
        buffer.writeInt(this.level);
        buffer.m_130055_(this.buyA);
        buffer.m_130055_(this.buyB);
        buffer.m_130055_(this.sell);
        buffer.writeInt(this.maxUses);
        buffer.writeInt(this.experience);
        buffer.writeFloat(this.multiplier);
    }

    public boolean isWandering() {
        return this.wandering;
    }

    public VillagerProfession getProfession() {
        return this.profession;
    }

    public int getLevel() {
        return this.level;
    }

    public ItemStack getBuyA() {
        return this.buyA.m_41777_();
    }

    public ItemStack getBuyB() {
        return this.buyB.m_41777_();
    }

    public ItemStack getSell() {
        return this.sell.m_41777_();
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public int getExperience() {
        return this.experience;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public abstract VillagerTrades.ItemListing toItemListing();

    public static class Builder<RECIPE extends LunarianTradeRecipe>
    extends ModRecipeBuilder<RECIPE> {
        private final BiFunction<ResourceLocation, Builder<RECIPE>, RECIPE> function;
        private boolean wandering = false;
        private VillagerProfession profession = VillagerProfession.f_35585_;
        private int level = 0;
        private ItemStack buyA = ItemStack.f_41583_;
        private ItemStack buyB = ItemStack.f_41583_;
        private ItemStack sell = ItemStack.f_41583_;
        private int maxUses = 0;
        private int experience = 0;
        private float multiplier = 0.0f;

        public Builder(BiFunction<ResourceLocation, ? extends Builder<RECIPE>, RECIPE> function) {
            this.function = function;
        }

        public Builder<RECIPE> wandring() {
            this.wandering = true;
            this.profession = null;
            return this;
        }

        public Builder<RECIPE> profession(VillagerProfession profession) {
            this.wandering = false;
            this.profession = profession;
            return this;
        }

        public Builder<RECIPE> level(int level) {
            this.level = level;
            return this;
        }

        public Builder<RECIPE> buy(ItemStack buyA) {
            return this.buy(buyA, ItemStack.f_41583_);
        }

        public Builder<RECIPE> buy(ItemStack buyA, ItemStack buyB) {
            this.buyA = buyA;
            this.buyB = buyB;
            return this;
        }

        public Builder<RECIPE> sell(ItemStack sell) {
            this.sell = sell;
            return this;
        }

        public Builder<RECIPE> maxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public Builder<RECIPE> experience(int experience) {
            this.experience = experience;
            return this;
        }

        public Builder<RECIPE> multiplier(float multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public boolean isWandering() {
            return this.wandering;
        }

        public VillagerProfession getProfession() {
            return this.profession;
        }

        public int getLevel() {
            return this.level;
        }

        public ItemStack getBuyA() {
            return this.buyA;
        }

        public ItemStack getBuyB() {
            return this.buyB;
        }

        public ItemStack getSell() {
            return this.sell;
        }

        public int getMaxUses() {
            return this.maxUses;
        }

        public int getExperience() {
            return this.experience;
        }

        public float getMultiplier() {
            return this.multiplier;
        }

        public ModRecipeBuilder.ModFinishedRecipe build(ResourceLocation id) {
            final LunarianTradeRecipe recipe = (LunarianTradeRecipe)this.function.apply(id, this);
            return new ModRecipeBuilder.ModFinishedRecipe(this, id){

                @Override
                public void m_7917_(JsonObject json) {
                    super.m_7917_(json);
                    recipe.toJson(json);
                }

                public RecipeSerializer<?> m_6637_() {
                    return recipe.m_7707_();
                }
            };
        }
    }

    public static class Serializer<RECIPE extends LunarianTradeRecipe>
    implements RecipeSerializer<RECIPE> {
        private final Function<ResourceLocation, RECIPE> function;

        public Serializer(Function<ResourceLocation, RECIPE> function) {
            this.function = function;
        }

        public RECIPE fromJson(ResourceLocation id, JsonObject json) {
            LunarianTradeRecipe recipe = (LunarianTradeRecipe)this.function.apply(id);
            recipe.fromJson(json);
            return (RECIPE)recipe;
        }

        public RECIPE fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            LunarianTradeRecipe recipe = (LunarianTradeRecipe)this.function.apply(id);
            recipe.fromNetwork(buffer);
            return (RECIPE)recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, RECIPE recipe) {
            ((LunarianTradeRecipe)recipe).toNetwork(buffer);
        }
    }
}

