/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntitySqueezer;

public class BlockSqueezer
extends BlockWithEntity {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final IntegerProperty HEIGHT = IntegerProperty.m_61631_((String)"height", (int)1, (int)7);
    private static final VoxelShape[] SHAPES_BLOCK = new VoxelShape[]{null, BlockSqueezer.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), BlockSqueezer.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), BlockSqueezer.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), BlockSqueezer.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), BlockSqueezer.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), BlockSqueezer.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), BlockSqueezer.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)};
    private static final VoxelShape[] SHAPES_STICKS = new VoxelShape[]{BlockSqueezer.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), BlockSqueezer.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), BlockSqueezer.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), BlockSqueezer.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] SHAPES = new VoxelShape[]{null, Shapes.m_83124_((VoxelShape)SHAPES_BLOCK[1], (VoxelShape[])SHAPES_STICKS), Shapes.m_83124_((VoxelShape)SHAPES_BLOCK[2], (VoxelShape[])SHAPES_STICKS), Shapes.m_83124_((VoxelShape)SHAPES_BLOCK[3], (VoxelShape[])SHAPES_STICKS), Shapes.m_83124_((VoxelShape)SHAPES_BLOCK[4], (VoxelShape[])SHAPES_STICKS), Shapes.m_83124_((VoxelShape)SHAPES_BLOCK[5], (VoxelShape[])SHAPES_STICKS), Shapes.m_83124_((VoxelShape)SHAPES_BLOCK[6], (VoxelShape[])SHAPES_STICKS), Shapes.m_83124_((VoxelShape)SHAPES_BLOCK[7], (VoxelShape[])SHAPES_STICKS)};

    public BlockSqueezer(BlockBehaviour.Properties properties) {
        super(properties, BlockEntitySqueezer::new);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(1)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BlockSqueezer.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_SQUEEZER, (BlockEntityTicker)new BlockEntitySqueezer.Ticker());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, HEIGHT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_8125_().m_122434_());
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if ((Integer)world.m_8055_(blockPos).m_61143_((Property)HEIGHT) == 1) {
            return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntitySqueezer.class).map(tile -> {
                ItemStack itemStack = player.m_150109_().m_36056_();
                ItemStack tileStack = tile.getInventory().m_8020_(0);
                if (itemStack.m_41619_() && !tileStack.m_41619_()) {
                    player.m_150109_().m_6836_(player.m_150109_().f_35977_, tileStack);
                    tile.getInventory().m_6836_(0, ItemStack.f_41583_);
                    tile.sendUpdate();
                    return InteractionResult.SUCCESS;
                }
                if (player.m_150109_().m_36054_(tileStack)) {
                    tile.getInventory().m_6836_(0, ItemStack.f_41583_);
                    tile.sendUpdate();
                    return InteractionResult.SUCCESS;
                }
                if (!itemStack.m_41619_() && tile.getInventory().m_8020_(0).m_41619_()) {
                    tile.getInventory().m_6836_(0, itemStack.m_41620_(1));
                    if (itemStack.m_41613_() <= 0) {
                        player.m_150109_().m_6836_(player.m_150109_().f_35977_, ItemStack.f_41583_);
                    }
                    tile.sendUpdate();
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        double motionY = entityIn.m_20184_().f_82480_;
        super.m_5548_(worldIn, entityIn);
        if (!entityIn.m_9236_().m_5776_() && motionY <= -0.37 && entityIn instanceof LivingEntity) {
            int i = Mth.m_14107_((double)entityIn.m_20185_());
            int j = Mth.m_14107_((double)(entityIn.m_20186_() - 0.2));
            int k = Mth.m_14107_((double)entityIn.m_20189_());
            BlockPos blockPos = new BlockPos(i, j, k);
            BlockState blockState = worldIn.m_8055_(blockPos);
            int steps = 1 + Mth.m_14107_((double)((-motionY - 0.37) * 5.0));
            if (entityIn.m_20186_() - (double)blockPos.m_123342_() - (double)this.getRelativeTopPositionTop(worldIn, blockPos, blockState) <= (double)0.1f && blockState.m_60734_() == this) {
                int newHeight = Math.min(7, (Integer)blockState.m_61143_((Property)HEIGHT) + steps);
                entityIn.m_9236_().m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(newHeight)));
                BlockEntityHelpers.get((BlockGetter)worldIn, (BlockPos)blockPos, BlockEntitySqueezer.class).ifPresent(tile -> tile.setItemHeight(Math.max(newHeight, tile.getItemHeight())));
            }
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, neighborBlock, fromPos, isMoving);
        if (!worldIn.f_46443_) {
            for (Direction enumfacing : Direction.values()) {
                if (!worldIn.m_46616_(pos.m_121945_(enumfacing), enumfacing)) continue;
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(1)));
                for (Entity entity : worldIn.m_45976_(Entity.class, new AABB(pos, pos.m_7918_(1, 1, 1)))) {
                    entity.m_20184_().m_82520_(0.0, 0.25, 0.0);
                    entity.m_20334_(0.0, 1.0, 0.0);
                }
                return;
            }
        }
    }

    public float getRelativeTopPositionTop(BlockGetter world, BlockPos blockPos, BlockState blockState) {
        return (float)(9 - (Integer)blockState.m_61143_((Property)HEIGHT)) * 0.125f;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPES[(Integer)blockState.m_61143_((Property)HEIGHT)];
    }

    public VoxelShape m_6079_(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        return SHAPES_BLOCK[(Integer)blockState.m_61143_((Property)HEIGHT)];
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPES_BLOCK[(Integer)blockState.m_61143_((Property)HEIGHT)];
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos blockPos) {
        return (int)(((double)((Integer)blockState.m_61143_((Property)HEIGHT)).intValue() - 1.0) / 6.0 * 15.0);
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!oldState.m_60713_(newState.m_60734_())) {
            BlockEntityHelpers.get((BlockGetter)level, (BlockPos)blockPos, BlockEntitySqueezer.class).ifPresent(tile -> {
                InventoryHelpers.dropItems((Level)level, (Container)tile.getInventory(), (BlockPos)blockPos);
                level.m_46717_(blockPos, oldState.m_60734_());
            });
            super.m_6810_(oldState, level, blockPos, newState, isMoving);
        }
    }
}

