/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeNbt
extends ValueTypeBase<ValueNbt>
implements IValueTypeNullable<ValueNbt>,
IValueTypeNamed<ValueNbt> {
    public ValueTypeNbt() {
        super("nbt", Helpers.RGBToInt((int)0, (int)170, (int)170), ChatFormatting.DARK_AQUA, ValueNbt.class);
    }

    @Override
    public ValueNbt getDefault() {
        return ValueNbt.of();
    }

    @Override
    public MutableComponent toCompactString(ValueNbt value) {
        return Component.m_237113_((String)this.toString(value));
    }

    @Override
    public Tag serialize(ValueNbt value) {
        CompoundTag tag = new CompoundTag();
        if (value.getRawValue().isPresent()) {
            tag.m_128365_("v", (Tag)value.getRawValue().get());
        }
        return tag;
    }

    @Override
    public ValueNbt deserialize(Tag value) {
        if (value instanceof CompoundTag && ((CompoundTag)value).m_128441_("v")) {
            return ValueNbt.of(((CompoundTag)value).m_128423_("v"));
        }
        return ValueNbt.of();
    }

    @Override
    public String toString(ValueNbt value) {
        return value.getRawValue().map(Object::toString).orElse("");
    }

    @Override
    public ValueNbt parseString(String value) throws EvaluationException {
        if (value.isEmpty()) {
            return ValueNbt.of();
        }
        try {
            return ValueNbt.of(new TagParser(new StringReader(value)).m_129371_());
        }
        catch (CommandSyntaxException e) {
            throw new EvaluationException(Component.m_237113_((String)e.getMessage()));
        }
    }

    @Override
    public boolean isNull(ValueNbt a) {
        return !a.getRawValue().isPresent();
    }

    public Tag filterBlacklistedTags(Tag tag) {
        if (tag instanceof CompoundTag) {
            boolean copied = false;
            CompoundTag compountTag = (CompoundTag)tag;
            for (String key : GeneralConfig.nbtTagBlacklist) {
                if (!compountTag.m_128441_(key)) continue;
                if (!copied) {
                    copied = true;
                    compountTag = compountTag.m_6426_();
                }
                compountTag.m_128473_(key);
            }
            return compountTag;
        }
        return tag;
    }

    @Override
    public String getName(ValueNbt value) {
        return this.toCompactString(value).getString();
    }

    public static class ValueNbt
    extends ValueOptionalBase<Tag> {
        private ValueNbt(Tag value) {
            super(ValueTypes.NBT, value);
        }

        @Override
        @Nullable
        protected Tag preprocessValue(@Nullable Tag value) {
            if (value != null) {
                return ValueTypes.NBT.filterBlacklistedTags(value);
            }
            return null;
        }

        public static ValueNbt of(@Nullable Tag value) {
            return new ValueNbt(value);
        }

        public static ValueNbt of(Optional<Tag> value) {
            return ValueNbt.of(value.orElse(null));
        }

        public static ValueNbt of() {
            return ValueNbt.of((Tag)null);
        }

        @Override
        protected boolean isEqual(Tag a, Tag b) {
            return a.equals(b);
        }

        @Override
        public String toString() {
            return this.getRawValue().map(Tag::toString).orElse("none");
        }
    }
}

