/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.aspect.property;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectPropertyTypeInstance;

public class AspectProperties
implements IAspectProperties {
    private final Map<IAspectPropertyTypeInstance, IValue> values = Maps.newLinkedHashMap();

    public AspectProperties(Collection<IAspectPropertyTypeInstance> propertyTypes) {
        for (IAspectPropertyTypeInstance propertyType : propertyTypes) {
            this.values.put(propertyType, (IValue)propertyType.getType().getDefault());
        }
    }

    public AspectProperties() {
    }

    @Override
    @Deprecated
    public Collection<IAspectPropertyTypeInstance> getTypes() {
        return Collections.unmodifiableCollection(this.values.keySet());
    }

    @Override
    public <T extends IValueType<V>, V extends IValue> V getValue(IAspectPropertyTypeInstance<T, V> type) {
        IValue value = this.values.get(type);
        if (value == null) {
            value = type.getType().getDefault();
        }
        return (V)value;
    }

    @Override
    public <T extends IValueType<V>, V extends IValue> void setValue(IAspectPropertyTypeInstance<T, V> type, V value) {
        this.values.put(type, value);
    }

    @Override
    public <T extends IValueType<V>, V extends IValue> void removeValue(IAspectPropertyTypeInstance<T, V> type) {
        this.values.remove(type);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag map = new ListTag();
        for (Map.Entry<IAspectPropertyTypeInstance, IValue> entry : this.values.entrySet()) {
            CompoundTag nbtEntry = new CompoundTag();
            nbtEntry.m_128359_("key", entry.getKey().getType().getUniqueName().toString());
            nbtEntry.m_128359_("label", entry.getKey().getTranslationKey());
            nbtEntry.m_128365_("value", ValueHelpers.serializeRaw(entry.getValue()));
            map.add((Object)nbtEntry);
        }
        tag.m_128365_("map", (Tag)map);
        return tag;
    }

    public void fromNBT(CompoundTag tag) {
        this.values.clear();
        ListTag map = tag.m_128437_("map", 10);
        for (int i = 0; i < map.size(); ++i) {
            CompoundTag nbtEntry = map.m_128728_(i);
            String valueTypeName = nbtEntry.m_128461_("key");
            IValueType type = ValueTypes.REGISTRY.getValueType(new ResourceLocation(valueTypeName));
            if (type == null) {
                IntegratedDynamics.clog(Level.ERROR, String.format("Could not find value type with name %s, skipping loading.", valueTypeName));
                continue;
            }
            Object value = ValueHelpers.deserializeRaw(type, nbtEntry.m_128423_("value"));
            String label = nbtEntry.m_128461_("label");
            if (value == null) {
                IntegratedDynamics.clog(Level.ERROR, String.format("The value type %s could not load its value, using default.", valueTypeName));
                value = type.getDefault();
            }
            this.values.put(new AspectPropertyTypeInstance(type, label), (IValue)value);
        }
    }

    @Override
    public IAspectProperties clone() {
        AspectProperties clone = new AspectProperties(this.getTypes());
        for (IAspectPropertyTypeInstance type : this.getTypes()) {
            clone.setValue(type, this.getValue(type));
        }
        return clone;
    }
}

