/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.path;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.core.path.Cluster;

public final class PathFinder {
    protected static TreeSet<ISidedPathElement> getConnectedElements(ISidedPathElement head, Set<DimPos> visitedPositions) {
        TreeSet elements = Sets.newTreeSet();
        if (!visitedPositions.contains(head.getPathElement().getPosition())) {
            elements.add(head);
            visitedPositions.add(head.getPathElement().getPosition());
        }
        for (ISidedPathElement neighbour : head.getPathElement().getReachableElements()) {
            if (visitedPositions.contains(neighbour.getPathElement().getPosition())) continue;
            elements.add(neighbour);
            visitedPositions.add(neighbour.getPathElement().getPosition());
        }
        HashSet neighbourElements = Sets.newHashSet();
        for (ISidedPathElement addedElement : elements) {
            neighbourElements.addAll(PathFinder.getConnectedElements(addedElement, visitedPositions));
        }
        elements.addAll(neighbourElements);
        return elements;
    }

    public static Cluster getConnectedCluster(ISidedPathElement head) {
        return new Cluster(PathFinder.getConnectedElements(head, Sets.newTreeSet()));
    }
}

