/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.inventory.slot.SlotRemoveOnly;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntityMechanicalSqueezer;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMechanicalMachine;

public class ContainerMechanicalSqueezer
extends ContainerMechanicalMachine<BlockEntityMechanicalSqueezer> {
    public static final String BUTTON_TOGGLE_FLUID_EJECT = "button_eject";
    private final Supplier<FluidStack> variableFluidStack = this.registerSyncedVariable(FluidStack.class, () -> ((BlockEntityMechanicalSqueezer)((Object)((Object)this.getTileSupplier().get()))).getTank().getFluid());
    private final Supplier<Integer> variableFluidCapacity = this.registerSyncedVariable(Integer.class, () -> ((BlockEntityMechanicalSqueezer)((Object)((Object)this.getTileSupplier().get()))).getTank().getCapacity());
    private final Supplier<Boolean> variableAutoEject = this.registerSyncedVariable(Boolean.class, () -> ((BlockEntityMechanicalSqueezer)((Object)((Object)this.getTileSupplier().get()))).isAutoEjectFluids());

    public ContainerMechanicalSqueezer(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(5), Optional.empty());
    }

    public ContainerMechanicalSqueezer(int id, Inventory playerInventory, Container inventory, Optional<BlockEntityMechanicalSqueezer> tileSupplier) {
        super(RegistryEntries.CONTAINER_MECHANICAL_SQUEEZER, id, playerInventory, inventory, tileSupplier);
        this.m_38897_(new Slot(inventory, 0, 44, 37));
        this.m_38897_((Slot)new SlotRemoveOnly(inventory, 1, 98, 29));
        this.m_38897_((Slot)new SlotRemoveOnly(inventory, 2, 116, 29));
        this.m_38897_((Slot)new SlotRemoveOnly(inventory, 3, 98, 47));
        this.m_38897_((Slot)new SlotRemoveOnly(inventory, 4, 116, 47));
        this.addPlayerInventory(playerInventory, this.offsetX + 8, this.offsetY + 86);
        this.putButtonAction(BUTTON_TOGGLE_FLUID_EJECT, (buttonId, container) -> this.getTileSupplier().ifPresent(tile -> tile.setAutoEjectFluids(!((BlockEntityMechanicalSqueezer)((Object)((Object)((Object)this.getTileSupplier().get())))).isAutoEjectFluids())));
    }

    @Nullable
    public FluidStack getFluidStack() {
        return this.variableFluidStack.get();
    }

    public int getFluidCapacity() {
        return this.variableFluidCapacity.get();
    }

    public boolean isAutoEjectFluids() {
        return this.variableAutoEject.get();
    }
}

