/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotRemoveOnly;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.api.part.read.IPartStateReader;
import org.cyclops.integrateddynamics.api.part.read.IPartTypeReader;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.part.event.PartReaderAspectEvent;

public class ContainerPartReader<P extends IPartTypeReader<P, S>, S extends IPartStateReader<P>>
extends ContainerMultipartAspects<P, S, IAspectRead> {
    public static final int ASPECT_BOX_HEIGHT = 36;
    private static final int SLOT_IN_X = 96;
    private static final int SLOT_IN_Y = 27;
    private static final int SLOT_OUT_X = 144;
    private static final int SLOT_OUT_Y = 27;
    private final Container outputSlots;
    private final BiMap<Integer, IAspectRead> readValueIds = HashBiMap.create();
    private final BiMap<Integer, IAspectRead> readColorIds = HashBiMap.create();

    public ContainerPartReader(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)new SimpleInventory(0, 1), PartHelpers.readPartTarget(packetBuffer), Optional.empty(), (IPartTypeReader)PartHelpers.readPart(packetBuffer));
    }

    public ContainerPartReader(int id, Inventory playerInventory, Container inventory, PartTarget target, Optional<IPartContainer> partContainer, P partType) {
        super(RegistryEntries.CONTAINER_PART_READER, id, playerInventory, inventory, target, partContainer, partType, partType.getReadAspects());
        int i;
        for (i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.m_38897_((Slot)new SlotVariable(this.inputSlots, i, 96, 27 + this.getAspectBoxHeight() * i));
            this.disableSlot(i);
        }
        this.outputSlots = new SimpleInventory(this.getUnfilteredItemCount(), 1);
        for (i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.m_38897_((Slot)new SlotRemoveOnly(this.outputSlots, i, 144, 27 + this.getAspectBoxHeight() * i));
            this.disableSlot(i + this.getUnfilteredItemCount());
        }
        this.addPlayerInventory(this.player.m_150109_(), 9, 131);
        for (IAspectRead aspectRead : this.getUnfilteredItems()) {
            this.readValueIds.put((Object)this.getNextValueId(), (Object)aspectRead);
            this.readColorIds.put((Object)this.getNextValueId(), (Object)aspectRead);
        }
    }

    protected boolean isAssertInventorySize() {
        return false;
    }

    protected int getSizeInventory() {
        return ((IPartTypeReader)this.getPartType()).getReadAspects().size() * 2;
    }

    @Override
    public int getAspectBoxHeight() {
        return 36;
    }

    @Override
    protected void enableSlot(int slotIndex, int row) {
        Slot slot = this.m_38853_(slotIndex);
        ContainerPartReader.setSlotPosX((Slot)slot, (int)96);
        ContainerPartReader.setSlotPosY((Slot)slot, (int)(27 + this.getAspectBoxHeight() * row));
    }

    protected void disableSlotOutput(int slotIndex) {
        Slot slot = this.m_38853_(slotIndex + this.getUnfilteredItemCount());
        ContainerPartReader.setSlotPosX((Slot)slot, (int)Integer.MIN_VALUE);
        ContainerPartReader.setSlotPosY((Slot)slot, (int)Integer.MIN_VALUE);
    }

    protected void enableSlotOutput(int slotIndex, int row) {
        Slot slot = this.m_38853_(slotIndex + this.getUnfilteredItemCount());
        ContainerPartReader.setSlotPosX((Slot)slot, (int)144);
        ContainerPartReader.setSlotPosY((Slot)slot, (int)(27 + this.getAspectBoxHeight() * row));
    }

    @Override
    public void onScroll(int firstRow) {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlotOutput(i);
        }
        super.onScroll(firstRow);
    }

    @Override
    protected void enableElementAt(int row, int elementIndex, IAspectRead element) {
        super.enableElementAt(row, elementIndex, element);
        this.enableSlotOutput(elementIndex, row);
    }

    @Override
    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.f_19853_.m_5776_()) {
            for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
                ItemStack itemStack = this.inputSlots.m_8016_(i);
                if (!itemStack.m_41619_()) {
                    player.m_36176_(itemStack, false);
                }
                if ((itemStack = this.outputSlots.m_8016_(i)).m_41619_()) continue;
                player.m_36176_(itemStack, false);
            }
        }
    }

    public void onDirty() {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            ItemStack itemStack = this.inputSlots.m_8020_(i);
            if (itemStack.m_41619_() || !this.outputSlots.m_8020_(i).m_41619_()) continue;
            ItemStack outputStack = this.writeAspectInfo(!this.player.f_19853_.m_5776_(), itemStack.m_41777_(), (IAspect)this.getUnfilteredItems().get(i));
            this.outputSlots.m_6836_(i, outputStack);
            this.inputSlots.m_7407_(i, 1);
        }
    }

    public void m_38946_() {
        super.m_38946_();
        try {
            if (!this.player.f_19853_.m_5776_()) {
                for (IAspectRead aspectRead : this.getUnfilteredItems()) {
                    Pair<MutableComponent, Integer> readValue;
                    if (((IPartStateReader)this.getPartState()).isEnabled()) {
                        IAspectVariable variable = ((IPartTypeReader)this.getPartType()).getVariable(this.getTarget(), (IPartStateReader)this.getPartState(), aspectRead);
                        readValue = ValueHelpers.getSafeReadableValue(variable);
                    } else {
                        readValue = Pair.of((Object)Component.m_237113_((String)"NO POWER"), (Object)0);
                    }
                    this.setReadValue(aspectRead, readValue);
                }
            }
        }
        catch (PartStateException e) {
            this.player.m_6915_();
        }
    }

    public void setReadValue(IAspectRead aspectRead, Pair<MutableComponent, Integer> readValue) {
        int valueId = (Integer)this.readValueIds.inverse().get((Object)aspectRead);
        int colorId = (Integer)this.readColorIds.inverse().get((Object)aspectRead);
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)valueId, (MutableComponent)((MutableComponent)readValue.getLeft()));
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)colorId, (int)((Integer)readValue.getRight()));
    }

    public Pair<Component, Integer> getReadValue(IAspectRead aspect) {
        int valueId = (Integer)this.readValueIds.inverse().get((Object)aspect);
        int colorId = (Integer)this.readColorIds.inverse().get((Object)aspect);
        try {
            return Pair.of((Object)ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)valueId), (Object)ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)colorId));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public ItemStack writeAspectInfo(boolean generateId, ItemStack itemStack, IAspect aspect) {
        ItemStack resultStack = super.writeAspectInfo(generateId, itemStack, aspect);
        if (this.player.f_19853_.m_5776_()) {
            return resultStack;
        }
        PartTarget target = this.getTarget();
        INetwork network = NetworkHelpers.getNetworkChecked((BlockGetter)target.getCenter().getPos().getLevel(true), target.getCenter().getPos().getBlockPos(), target.getCenter().getSide());
        IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked(network);
        PartReaderAspectEvent<IPartTypeReader, IPartStateReader, IAspectRead> event = new PartReaderAspectEvent<IPartTypeReader, IPartStateReader, IAspectRead>(network, partNetwork, target, (IPartTypeReader)this.getPartType(), (IPartStateReader)this.getPartState(), this.player, (IAspectRead)aspect, resultStack);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getItemStack();
    }
}

