/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class ItemWrench
extends Item {
    private static final Map<String, Mode> NAMED_MODES = Maps.newHashMap();

    public ItemWrench(Item.Properties properties) {
        super(properties);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_36341_() && !world.m_5776_()) {
            this.incrementMode(itemStack);
            player.m_5661_((Component)Component.m_237110_((String)"item.integrateddynamics.wrench.mode", (Object[])new Object[]{Component.m_237115_((String)this.getMode(itemStack).getLabel())}), true);
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        return super.m_7203_(world, player, hand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        if (context.m_43723_() != null && context.m_43723_().m_36341_()) {
            switch (this.getMode(itemStack)) {
                case OFFSET: {
                    itemStack.m_41784_().m_128356_("pos", context.m_8083_().m_121878_());
                    context.m_43723_().m_5661_((Component)Component.m_237110_((String)"item.integrateddynamics.wrench.mode.offset.saved", (Object[])new Object[]{context.m_8083_().m_123344_()}), true);
                    return InteractionResult.SUCCESS;
                }
                case OFFSET_SIDE: {
                    itemStack.m_41784_().m_128356_("pos", context.m_8083_().m_121878_());
                    itemStack.m_41784_().m_128356_("side", (long)context.m_43719_().ordinal());
                    context.m_43723_().m_5661_((Component)Component.m_237110_((String)"item.integrateddynamics.wrench.mode.offset_side.saved", (Object[])new Object[]{context.m_8083_().m_123344_(), context.m_43719_().m_7912_()}), true);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        if (context.m_43723_() != null && context.m_43723_().m_36341_()) {
            return super.m_6225_(context);
        }
        ItemStack itemStack = context.m_43722_();
        switch (this.getMode(itemStack)) {
            case DEFAULT: {
                blockState = context.m_43719_().m_122434_() == Direction.Axis.Y && blockState.m_61138_((Property)BlockStateProperties.f_61372_) ? (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)(blockState.m_61143_((Property)BlockStateProperties.f_61372_) == Direction.UP ? Direction.DOWN : Direction.UP)) : (context.m_43719_().m_122434_() != Direction.Axis.Y && blockState.m_61138_((Property)BlockStateProperties.f_61372_) && ((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_() == Direction.Axis.Y ? (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_43719_()) : blockState.rotate((LevelAccessor)context.m_43725_(), context.m_8083_(), Rotation.CLOCKWISE_90));
                context.m_43725_().m_46597_(context.m_8083_(), blockState);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Mode getMode(ItemStack itemStack) {
        Mode mode;
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && (mode = NAMED_MODES.get(tag.m_128461_("mode"))) != null) {
            return mode;
        }
        return Mode.DEFAULT;
    }

    public void setMode(ItemStack itemStack, Mode mode) {
        itemStack.m_41784_().m_128359_("mode", mode.getName());
    }

    public void incrementMode(ItemStack itemStack) {
        Mode mode = this.getMode(itemStack);
        int modeId = mode.ordinal();
        Mode nextMode = Mode.values()[(modeId + 1) % Mode.values().length];
        this.setMode(itemStack, nextMode);
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            tag.m_128473_("pos");
            tag.m_128473_("side");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        CompoundTag tag = itemStack.m_41783_();
        Mode mode = this.getMode(itemStack);
        list.add((Component)Component.m_237110_((String)"item.integrateddynamics.wrench.mode", (Object[])new Object[]{Component.m_237115_((String)mode.getLabel())}));
        if (tag != null) {
            if (tag.m_128441_("pos")) {
                list.add((Component)Component.m_237110_((String)"item.integrateddynamics.wrench.mode.offset.pos", (Object[])new Object[]{BlockPos.m_122022_((long)tag.m_128454_("pos")).m_123344_()}).m_130940_(ChatFormatting.GRAY));
            }
            if (tag.m_128441_("side")) {
                list.add((Component)Component.m_237110_((String)"item.integrateddynamics.wrench.mode.offset_side.side", (Object[])new Object[]{Direction.values()[tag.m_128451_("side")].m_7912_()}).m_130940_(ChatFormatting.GRAY));
            }
        }
        list.add((Component)Component.m_237115_((String)(mode.getLabel() + ".info")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    public <P extends IPartType<P, S>, S extends IPartState<P>> InteractionResult performPartAction(BlockHitResult hit, IPartType<P, S> partType, IPartState<P> partState, ItemStack itemStack, Player player, InteractionHand hand, PartPos center) {
        Mode mode = this.getMode(itemStack);
        CompoundTag tag = itemStack.m_41783_();
        switch (mode) {
            case OFFSET: {
                if (tag.m_128441_("pos")) {
                    Vec3i offset = this.determineOffset(hit, tag);
                    if (partType.setTargetOffset(partState, center, offset)) {
                        player.m_5661_((Component)Component.m_237115_((String)"item.integrateddynamics.wrench.mode.offset.success"), true);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"item.integrateddynamics.wrench.mode.offset.fail"), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"item.integrateddynamics.wrench.mode.offset.incomplete"), true);
                }
                return InteractionResult.SUCCESS;
            }
            case OFFSET_SIDE: {
                if (tag.m_128441_("pos") && tag.m_128441_("side")) {
                    Vec3i offset = this.determineOffset(hit, tag);
                    Direction side = Direction.values()[tag.m_128451_("side")];
                    if (partType.setTargetOffset(partState, center, offset)) {
                        partType.setTargetSideOverride(partState, side);
                        player.m_5661_((Component)Component.m_237115_((String)"item.integrateddynamics.wrench.mode.offset_side.success"), true);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"item.integrateddynamics.wrench.mode.offset.fail"), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"item.integrateddynamics.wrench.mode.offset.incomplete"), true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected Vec3i determineOffset(BlockHitResult hit, CompoundTag tag) {
        BlockPos source = hit.m_82425_().m_121945_(hit.m_82434_());
        BlockPos targetAbs = BlockPos.m_122022_((long)tag.m_128454_("pos"));
        return new Vec3i(targetAbs.m_123341_() - source.m_123341_(), targetAbs.m_123342_() - source.m_123342_(), targetAbs.m_123343_() - source.m_123343_());
    }

    public static enum Mode {
        DEFAULT("integrateddynamics:default", "item.integrateddynamics.wrench.mode.default"),
        OFFSET("integrateddynamics:offset", "item.integrateddynamics.wrench.mode.offset"),
        OFFSET_SIDE("integrateddynamics:offset_side", "item.integrateddynamics.wrench.mode.offset_side");

        private final String name;
        private final String label;

        private Mode(String name, String label) {
            this.name = name;
            this.label = label;
            NAMED_MODES.put(name, this);
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

