/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiBigLight;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiHybridGauge;
import mekanism.client.gui.element.graph.GuiDoubleGraph;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.jei.MekanismJEIRecipeType;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.gui.element.GuiFissionReactorTab;
import mekanism.generators.client.jei.GeneratorsJEIRecipeType;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.network.to_server.PacketGeneratorsGuiInteract;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiFissionReactor
extends GuiMekanismTile<TileEntityFissionReactorCasing, MekanismTileContainer<TileEntityFissionReactorCasing>> {
    private TranslationButton activateButton;
    private TranslationButton scramButton;
    private GuiDoubleGraph heatGraph;

    public GuiFissionReactor(MekanismTileContainer<TileEntityFissionReactorCasing> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97726_ = 195;
        this.f_97727_ += 89;
        this.f_97730_ = 6;
        this.f_97731_ = this.f_97727_ - 92;
        this.f_97729_ = 5;
        this.dynamicSlots = true;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiFissionReactorTab((IGuiWrapper)this, (TileEntityFissionReactorCasing)this.tile, GuiFissionReactorTab.FissionReactorTab.STAT));
        this.addRenderableWidget((GuiElement)new GuiInnerScreen((IGuiWrapper)this, 45, 17, 105, 56, () -> {
            FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
            return List.of(MekanismLang.STATUS.translate(new Object[]{multiblock.isActive() ? EnumColor.BRIGHT_GREEN : EnumColor.RED, BooleanStateDisplay.ActiveDisabled.of((boolean)multiblock.isActive())}), GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{multiblock.lastBurnRate}), GeneratorsLang.FISSION_HEATING_RATE.translate(new Object[]{TextUtils.format((long)multiblock.lastBoilRate)}), MekanismLang.TEMPERATURE.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getTempColor(), MekanismUtils.getTemperatureDisplay((double)multiblock.heatCapacitor.getTemperature(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), GeneratorsLang.FISSION_DAMAGE.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getDamageColor(), ((TileEntityFissionReactorCasing)this.tile).getDamageString()}));
        }).spacing(2).jeiCategories(new MekanismJEIRecipeType[]{GeneratorsJEIRecipeType.FISSION}));
        this.addRenderableWidget((GuiElement)new GuiHybridGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).gasCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).fluidCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getFluidTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 6, 13).setLabel((Component)GeneratorsLang.FISSION_COOLANT_TANK.translateColored(EnumColor.AQUA, new Object[0])));
        this.addRenderableWidget((GuiElement)new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).fuelTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 25, 13).setLabel((Component)GeneratorsLang.FISSION_FUEL_TANK.translateColored(EnumColor.DARK_GREEN, new Object[0])));
        this.addRenderableWidget((GuiElement)new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).heatedCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 152, 13).setLabel((Component)GeneratorsLang.FISSION_HEATED_COOLANT_TANK.translateColored(EnumColor.ORANGE, new Object[0])));
        this.addRenderableWidget((GuiElement)new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).wasteTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 171, 13).setLabel((Component)GeneratorsLang.FISSION_WASTE_TANK.translateColored(EnumColor.BROWN, new Object[0])));
        this.addRenderableWidget((GuiElement)new GuiHeatTab((IGuiWrapper)this, () -> {
            Component environment = MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).lastEnvironmentLoss, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(new Object[]{environment}));
        }));
        this.activateButton = (TranslationButton)this.addRenderableWidget((GuiElement)new TranslationButton((IGuiWrapper)this, 6, 75, 81, 16, GeneratorsLang.FISSION_ACTIVATE, () -> MekanismGenerators.packetHandler().sendToServer(new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.FISSION_ACTIVE, (BlockEntity)this.tile, 1.0)), null, () -> EnumColor.DARK_GREEN){

            public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
                super.renderForeground(matrix, mouseX, mouseY);
                if (!this.f_93623_ && ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)GuiFissionReactor.this.tile).getMultiblock()).isForceDisabled()) {
                    this.f_93623_ = true;
                    if (this.isMouseOverCheckWindows(mouseX, mouseY)) {
                        matrix.m_85836_();
                        matrix.m_85837_((double)(-this.getGuiLeft()), (double)(-this.getGuiTop()), 0.0);
                        this.displayTooltips(matrix, mouseX, mouseY, new Component[]{GeneratorsLang.FISSION_FORCE_DISABLED.translate(new Object[0])});
                        matrix.m_85849_();
                    }
                    this.f_93623_ = false;
                }
            }
        });
        this.scramButton = (TranslationButton)this.addRenderableWidget((GuiElement)new TranslationButton((IGuiWrapper)this, 89, 75, 81, 16, (ILangEntry)GeneratorsLang.FISSION_SCRAM, () -> MekanismGenerators.packetHandler().sendToServer(new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.FISSION_ACTIVE, (BlockEntity)this.tile, 0.0)), null, () -> EnumColor.DARK_RED));
        this.addRenderableWidget((GuiElement)new GuiBigLight((IGuiWrapper)this, 173, 76, ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock())::isActive));
        this.addRenderableWidget((GuiElement)new GuiDynamicHorizontalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public Component getTooltip() {
                return MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactor)GuiFissionReactor.this).tile).getMultiblock()).heatCapacitor.getTemperature(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true);
            }

            public double getLevel() {
                return Math.min(1.0, ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactor)GuiFissionReactor.this).tile).getMultiblock()).heatCapacitor.getTemperature() / 1800.0);
            }
        }, 5, 102, this.f_97726_ - 12));
        this.heatGraph = (GuiDoubleGraph)this.addRenderableWidget((GuiElement)new GuiDoubleGraph((IGuiWrapper)this, 5, 123, this.f_97726_ - 10, 38, temp -> MekanismUtils.getTemperatureDisplay((double)temp, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)));
        this.heatGraph.setMinScale(1600.0);
        this.updateButtons();
    }

    private void updateButtons() {
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
        this.activateButton.f_93623_ = !multiblock.isActive() && !multiblock.isForceDisabled();
        this.scramButton.f_93623_ = multiblock.isActive();
    }

    protected void drawForegroundText(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        this.updateButtons();
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        this.drawString(matrix, (Component)MekanismLang.TEMPERATURE_LONG.translate(new Object[]{""}), 6, 93, this.titleTextColor());
        this.drawString(matrix, (Component)GeneratorsLang.FISSION_HEAT_GRAPH.translate(new Object[0]), 6, 114, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    public void m_181908_() {
        super.m_181908_();
        this.heatGraph.addData(((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).heatCapacitor.getTemperature());
    }
}

