/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.registries.MekanismGases;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class TurbineGasTank
extends MultiblockChemicalTankBuilder.MultiblockGasTank {
    private final TurbineMultiblockData multiblock;

    public TurbineGasTank(TurbineMultiblockData multiblock, @Nullable IContentsListener listener) {
        super(multiblock::getSteamCapacity, multiblock.notExternalFormedBiPred(), multiblock.formedBiPred(), gas -> gas == MekanismGases.STEAM.getChemical(), null, listener);
        this.multiblock = multiblock;
    }

    public GasStack insert(@NotNull GasStack stack, Action action, AutomationType automationType) {
        GasStack returned = (GasStack)super.insert((ChemicalStack)stack, action, automationType);
        if (action == Action.EXECUTE && this.multiblock.isFormed()) {
            this.multiblock.newSteamInput += stack.getAmount() - returned.getAmount();
        }
        return returned;
    }
}

