/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;

@ParametersAreNonnullByDefault
public class ForgedVentBlock
extends TetraWaterloggedBlock
implements IInteractiveBlock {
    public static final IntegerProperty propRotation = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)3);
    public static final BooleanProperty propX = BooleanProperty.m_61465_((String)"x");
    public static final BooleanProperty propBroken = BooleanProperty.m_61465_((String)"broken");
    public static final String identifier = "forged_vent";
    private static final ResourceLocation boltLootTable = new ResourceLocation("tetra", "forged/bolt_break");
    private static final ResourceLocation ventLootTable = new ResourceLocation("tetra", "forged/vent_break");
    public static final BlockInteraction[] interactions = new BlockInteraction[]{new BlockInteraction(TetraToolActions.hammer, 3, Direction.EAST, 1.0f, 4.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)0)), ForgedVentBlock::breakBolt), new BlockInteraction(TetraToolActions.hammer, 3, Direction.EAST, 1.0f, 4.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)1)), ForgedVentBlock::breakBolt), new BlockInteraction(TetraToolActions.hammer, 3, Direction.EAST, 12.0f, 15.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)2)), ForgedVentBlock::breakBolt), new BlockInteraction(TetraToolActions.hammer, 3, Direction.EAST, 12.0f, 15.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)3)), ForgedVentBlock::breakBolt), new BlockInteraction(TetraToolActions.hammer, 3, Direction.WEST, 12.0f, 15.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)0)), ForgedVentBlock::breakBolt), new BlockInteraction(TetraToolActions.hammer, 3, Direction.WEST, 12.0f, 15.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)1)), ForgedVentBlock::breakBolt), new BlockInteraction(TetraToolActions.hammer, 3, Direction.WEST, 1.0f, 4.0f, 12.0f, 15.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)2)), ForgedVentBlock::breakBolt), new BlockInteraction(TetraToolActions.hammer, 3, Direction.WEST, 1.0f, 4.0f, 1.0f, 4.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)false)).where(propRotation, Predicates.equalTo((Object)3)), ForgedVentBlock::breakBolt), new BlockInteraction(TetraToolActions.pry, 1, Direction.EAST, 7.0f, 11.0f, 8.0f, 12.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)true)), ForgedVentBlock::breakBeam), new BlockInteraction(TetraToolActions.pry, 1, Direction.WEST, 7.0f, 11.0f, 8.0f, 12.0f, new PropertyMatcher().where(propBroken, Predicates.equalTo((Object)true)), ForgedVentBlock::breakBeam)};
    @ObjectHolder(registryName="block", value="tetra:forged_vent")
    public static ForgedVentBlock instance;

    public ForgedVentBlock() {
        super(ForgedBlockCommon.propertiesNotSolid);
    }

    private static boolean breakBolt(Level world, BlockPos pos, BlockState blockState, Player player, InteractionHand hand, Direction hitFace) {
        world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)propBroken, (Comparable)Boolean.valueOf(true)), 2);
        if (!world.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (player != null) {
                BlockInteraction.dropLoot(ventLootTable, player, hand, serverWorld, blockState);
            } else {
                BlockInteraction.dropLoot(ventLootTable, serverWorld, pos, blockState);
            }
            serverWorld.m_5594_(null, pos, SoundEvents.f_12600_, SoundSource.PLAYERS, 0.4f, 0.5f);
        }
        return true;
    }

    private static boolean breakBeam(Level world, BlockPos pos, BlockState blockState, @Nullable Player player, @Nullable InteractionHand hand, Direction hitFace) {
        List<BlockPos> connectedVents = ForgedVentBlock.getConnectedBlocks(world, pos, new LinkedList<BlockPos>(), (Boolean)blockState.m_61143_((Property)propX));
        if (connectedVents.stream().anyMatch(blockPos -> (Boolean)world.m_8055_(blockPos).m_61143_((Property)propBroken) == false)) {
            if (!world.f_46443_) {
                world.m_5594_(null, pos, SoundEvents.f_12011_, SoundSource.PLAYERS, 0.4f, 2.0f);
            }
            return false;
        }
        connectedVents.forEach(blockPos -> {
            world.m_5898_(null, 2001, blockPos, Block.m_49956_((BlockState)world.m_8055_(blockPos)));
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
        });
        if (!world.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (player != null) {
                BlockInteraction.dropLoot(ventLootTable, player, hand, serverWorld, blockState);
            } else {
                BlockInteraction.dropLoot(ventLootTable, serverWorld, pos, blockState);
            }
        }
        return true;
    }

    private static List<BlockPos> getConnectedBlocks(Level world, BlockPos pos, List<BlockPos> visited, boolean isXAxis) {
        if (!visited.contains(pos) && world.m_8055_(pos).m_60734_() instanceof ForgedVentBlock) {
            visited.add(pos);
            ForgedVentBlock.getConnectedBlocks(world, pos.m_7494_(), visited, isXAxis);
            ForgedVentBlock.getConnectedBlocks(world, pos.m_7495_(), visited, isXAxis);
            if (isXAxis) {
                ForgedVentBlock.getConnectedBlocks(world, pos.m_122029_(), visited, isXAxis);
                ForgedVentBlock.getConnectedBlocks(world, pos.m_122024_(), visited, isXAxis);
            } else {
                ForgedVentBlock.getConnectedBlocks(world, pos.m_122012_(), visited, isXAxis);
                ForgedVentBlock.getConnectedBlocks(world, pos.m_122019_(), visited, isXAxis);
            }
        }
        return visited;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{propRotation, propX, propBroken});
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(Level world, BlockPos pos, BlockState state, Direction face, Collection<ToolAction> tools) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(world, pos, state, (Boolean)state.m_61143_((Property)propX) != false ? Direction.EAST : Direction.SOUTH, face, tools)).toArray(BlockInteraction[]::new);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        return BlockInteraction.attemptInteraction(world, state, pos, player, hand, rayTrace);
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = super.m_5573_(context);
        Direction playerFacing = context.m_43723_() != null ? context.m_43723_().m_6350_() : Direction.NORTH;
        blockState = blockState != null ? blockState : this.m_49966_();
        blockState = (BlockState)blockState.m_61124_((Property)propX, (Comparable)Boolean.valueOf(Direction.Axis.X.equals((Object)playerFacing.m_122434_())));
        int rotation = 0;
        if (Direction.EAST.equals((Object)playerFacing) || Direction.SOUTH.equals((Object)playerFacing)) {
            rotation = 2;
        }
        if (context.m_43719_() != Direction.UP && (context.m_43719_() == Direction.DOWN || context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5)) {
            ++rotation;
        }
        blockState = (BlockState)((BlockState)blockState.m_61124_((Property)propRotation, (Comparable)Integer.valueOf(rotation))).m_61124_((Property)propBroken, (Comparable)Boolean.valueOf(false));
        return blockState;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        boolean isXAxis = (Boolean)state.m_61143_((Property)propX);
        if (rot.equals((Object)Rotation.CLOCKWISE_90) || rot.equals((Object)Rotation.COUNTERCLOCKWISE_90)) {
            state = (BlockState)state.m_61124_((Property)propX, (Comparable)Boolean.valueOf(!isXAxis));
        }
        if (rot.equals((Object)Rotation.CLOCKWISE_180) || !isXAxis && rot.equals((Object)Rotation.CLOCKWISE_90) || isXAxis && rot.equals((Object)Rotation.COUNTERCLOCKWISE_90)) {
            return (BlockState)state.m_61124_((Property)propRotation, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)propRotation) ^ 2));
        }
        return (BlockState)state.m_61124_((Property)propRotation, (Comparable)((Integer)state.m_61143_((Property)propRotation)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext contex) {
        if (((Boolean)state.m_61143_((Property)propX)).booleanValue()) {
            return ForgedVentBlock.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        }
        return ForgedVentBlock.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 0;
    }
}

