/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiRect;
import se.mickelus.tetra.items.modular.IModularItem;

@ParametersAreNonnullByDefault
public class GuiModuleImprovement
extends GuiElement {
    private final List<Component> tooltipLines;
    private final Runnable hoverHandler;
    private final Runnable blurHandler;

    public GuiModuleImprovement(int x, int y, String improvement, int level, int color, Runnable hoverHandler, Runnable blurHandler) {
        super(x, y, 4, 4);
        this.addChild((GuiElement)new GuiRect(0, 1, this.width, 1, color));
        this.tooltipLines = new ArrayList<Component>();
        if (level < 0) {
            this.tooltipLines.add((Component)Component.m_237113_((String)("-" + IModularItem.getImprovementName(improvement, 0))).m_130940_(ChatFormatting.DARK_RED));
        } else {
            this.tooltipLines.add((Component)Component.m_237113_((String)IModularItem.getImprovementName(improvement, level)));
        }
        Arrays.stream(IModularItem.getImprovementDescription(improvement).split("\\\\n")).map(line -> Component.m_237113_((String)line).m_130940_(ChatFormatting.DARK_GRAY)).forEachOrdered(this.tooltipLines::add);
        this.hoverHandler = hoverHandler;
        this.blurHandler = blurHandler;
    }

    public List<Component> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltipLines;
        }
        return null;
    }

    protected void onFocus() {
        super.onFocus();
        this.hoverHandler.run();
    }

    protected void onBlur() {
        super.onBlur();
        this.blurHandler.run();
    }
}

