/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;

public class ItemLayerModel
implements IUnbakedGeometry<net.minecraftforge.client.model.ItemLayerModel> {
    private final Int2ObjectMap<List<IQuadTransformer>> layerTransformers;
    private final Int2ObjectMap<ResourceLocation> renderTypeNames;
    private List<Material> textures;

    public ItemLayerModel(List<Material> textures, Int2ObjectMap<List<IQuadTransformer>> layerTransformers, Int2ObjectMap<ResourceLocation> renderTypeNames) {
        this.textures = textures;
        this.layerTransformers = layerTransformers;
        this.renderTypeNames = renderTypeNames;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite particle = spriteGetter.apply(context.hasMaterial("particle") ? context.getMaterial("particle") : (this.textures.size() > 0 ? this.textures.get(0) : new Material(TextureAtlas.f_118259_, MissingTextureAtlasSprite.m_118071_())));
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(rootTransform), modelState.m_7538_());
        }
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)context, (TextureAtlasSprite)particle, (ItemOverrides)overrides, (ItemTransforms)context.getTransforms());
        for (int i = 0; i < this.textures.size(); ++i) {
            ResourceLocation renderTypeName;
            TextureAtlasSprite sprite = spriteGetter.apply(this.textures.get(i));
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)i, (TextureAtlasSprite)sprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            if (this.layerTransformers.containsKey(i)) {
                ((List)this.layerTransformers.get(i)).forEach(transformer -> transformer.processInPlace(quads));
            }
            RenderTypeGroup renderTypes = (renderTypeName = (ResourceLocation)this.renderTypeNames.get(i)) != null ? context.getRenderType(renderTypeName) : new RenderTypeGroup(RenderType.m_110451_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
            builder.addQuads(renderTypes, (Collection)quads);
        }
        return builder.build();
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.textures;
    }
}

