/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.client.model.BakingContextWrapper;
import se.mickelus.tetra.client.model.ColorQuadTransformer;
import se.mickelus.tetra.client.model.ItemLayerModel;
import se.mickelus.tetra.client.model.QuadTransformerBuilder;
import se.mickelus.tetra.client.model.TetraSeparateTransformsModel;
import se.mickelus.tetra.client.model.UnresolvedItemModel;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.TransformKey;

@ParametersAreNonnullByDefault
public class ModularOverrideList
extends ItemOverrides {
    private static final Map<TransformKey, ItemTransforms.TransformType> transformMap = ImmutableMap.builder().put((Object)TransformKey.none, (Object)ItemTransforms.TransformType.NONE).put((Object)TransformKey.thirdperson_lefthand, (Object)ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).put((Object)TransformKey.thirdperson_righthand, (Object)ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).put((Object)TransformKey.firstperson_lefthand, (Object)ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND).put((Object)TransformKey.firstperson_righthand, (Object)ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).put((Object)TransformKey.head, (Object)ItemTransforms.TransformType.HEAD).put((Object)TransformKey.gui, (Object)ItemTransforms.TransformType.GUI).put((Object)TransformKey.ground, (Object)ItemTransforms.TransformType.GROUND).put((Object)TransformKey.fixed, (Object)ItemTransforms.TransformType.FIXED).build();
    private static final Logger logger = LogManager.getLogger();
    private final Cache<CacheKey, BakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final UnresolvedItemModel model;
    private final IGeometryBakingContext context;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelState;
    private final ResourceLocation modelLocation;

    public ModularOverrideList(UnresolvedItemModel model, IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation) {
        this.model = model;
        this.context = context;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelState = modelState;
        this.modelLocation = modelLocation;
    }

    public void clearCache() {
        logger.debug("Clearing item model cache for " + this.modelLocation);
        this.bakedModelCache.invalidateAll();
    }

    @Nullable
    public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int renderId) {
        CompoundTag baseTag = stack.m_41783_();
        BakedModel result = originalModel;
        if (baseTag != null && !baseTag.m_128456_()) {
            CacheKey key = this.getCacheKey(stack, entity, originalModel);
            try {
                result = (BakedModel)this.bakedModelCache.get((Object)key, () -> this.getOverrideModel(stack, (Level)world, entity));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected BakedModel getOverrideModel(ItemStack itemStack, @Nullable Level world, @Nullable LivingEntity entity) {
        IModularItem item = (IModularItem)itemStack.m_41720_();
        String transformVariant = item.getTransformVariant(itemStack, entity);
        ItemTransforms cameraTransforms = this.model.getCameraTransforms(transformVariant);
        BakingContextWrapper contextWrapper = new BakingContextWrapper(this.context, cameraTransforms);
        ImmutableList<ModuleModel> models = item.getModels(itemStack, entity);
        Set perspectives = models.stream().map(model -> model.perspectives).filter(Objects::nonNull).flatMap(Arrays::stream).map(transformMap::get).filter(Objects::nonNull).collect(Collectors.toSet());
        ItemLayerModel model2 = this.createLayerModel(this.filterModels((List<ModuleModel>)models, null));
        if (!perspectives.isEmpty()) {
            Map<ItemTransforms.TransformType, ItemLayerModel> perspectiveModels = perspectives.stream().collect(Collectors.toUnmodifiableMap(p -> p, p -> this.createLayerModel(this.filterModels((List<ModuleModel>)models, (ItemTransforms.TransformType)p))));
            TetraSeparateTransformsModel transformsModel = new TetraSeparateTransformsModel(model2, perspectiveModels);
            return transformsModel.bake(contextWrapper, this.bakery, this.spriteGetter, this.modelState, ItemOverrides.f_111734_, this.modelLocation);
        }
        return model2.bake(contextWrapper, this.bakery, this.spriteGetter, this.modelState, ItemOverrides.f_111734_, this.modelLocation);
    }

    protected ItemLayerModel createLayerModel(List<ModuleModel> models) {
        ImmutableList textures = models.stream().map(moduleModel -> new Material(TextureAtlas.f_118259_, moduleModel.location)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        Int2ObjectOpenHashMap renderTypes = new Int2ObjectOpenHashMap();
        QuadTransformerBuilder builder = new QuadTransformerBuilder();
        for (int i = 0; i < models.size(); ++i) {
            ModuleModel model = models.get(i);
            if (model.tint != -1) {
                builder.add(i, new ColorQuadTransformer(model.tint));
            }
            if (model.emission >= 0 && model.emission < 16) {
                builder.add(i, QuadTransformers.settingEmissivity((int)model.emission));
            }
            if (model.transform != null) {
                builder.add(i, QuadTransformers.applying((Transformation)model.transform));
            }
            if (model.renderType == null) continue;
            renderTypes.put(i, (Object)model.renderType);
        }
        return new ItemLayerModel((List<Material>)textures, builder.get(), (Int2ObjectMap<ResourceLocation>)renderTypes);
    }

    protected List<ModuleModel> filterModels(List<ModuleModel> models, @Nullable ItemTransforms.TransformType perspective) {
        return models.stream().filter(model -> model.perspectives == null || ArrayUtils.contains((Object[])model.perspectives, (Object)perspective) != model.invertPerspectives).toList();
    }

    protected CacheKey getCacheKey(ItemStack itemStack, LivingEntity entity, BakedModel original) {
        return new CacheKey(original, ((IModularItem)itemStack.m_41720_()).getModelCacheKey(itemStack, entity));
    }

    protected static class CacheKey {
        final BakedModel parent;
        final String data;

        protected CacheKey(BakedModel parent, String hash) {
            this.parent = parent;
            this.data = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.parent != null ? this.parent != cacheKey.parent : cacheKey.parent != null) {
                return false;
            }
            return Objects.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            int result = this.parent != null ? this.parent.hashCode() : 0;
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }
    }
}

