/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.client.particle.SweepingStrikeParticleOption;

@MethodsReturnNonnullByDefault
public class SweepingStrikeParticle
extends TextureSheetParticle {
    @OnlyIn(value=Dist.CLIENT)
    ParticleRenderType renderType = new ParticleRenderType(){

        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.m_69464_();
            RenderSystem.m_69461_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
        }

        public String toString() {
            return "PARTICLE_SHEET_LIT";
        }
    };
    private static final Vector3f ROTATION_VECTOR = (Vector3f)Util.m_137469_((Object)new Vector3f(0.5f, 0.5f, 0.5f), Vector3f::m_122278_);
    private static final Vector3f TRANSFORM_VECTOR = new Vector3f(-1.0f, -1.0f, 0.0f);
    private final boolean reverse;
    private final SpriteSet sprites;
    private final float pitch;
    private final float yaw;

    protected SweepingStrikeParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, int lifetime, boolean reverse, float pitch, float yaw) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        float shade;
        this.f_107227_ = shade = 0.6f + this.f_107223_.m_188501_() * 0.4f;
        this.f_107228_ = shade;
        this.f_107229_ = shade;
        this.f_107663_ = 1.0f;
        this.pitch = pitch / 180.0f * (float)Math.PI;
        this.yaw = yaw / 180.0f * (float)Math.PI;
        this.sprites = spriteSet;
        this.f_107225_ = lifetime;
        this.reverse = reverse;
        this.m_108339_(spriteSet);
    }

    public ParticleRenderType m_7556_() {
        return this.renderType;
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTicks) {
        this.renderRotatedParticle(consumer, camera, partialTicks, p_234005_ -> {
            p_234005_.m_80148_(Vector3f.f_122225_.m_122270_(-this.yaw));
            p_234005_.m_80148_(Vector3f.f_122223_.m_122270_(this.pitch + 1.0471976f));
        });
    }

    private void renderRotatedParticle(VertexConsumer consumer, Camera camera, float partialTicks, Consumer<Quaternion> transformApplier) {
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(this.f_107212_ - vec3.m_7096_());
        float y = (float)(this.f_107213_ - vec3.m_7098_());
        float z = (float)(this.f_107214_ - vec3.m_7094_());
        Quaternion quaternion = new Quaternion(ROTATION_VECTOR, 0.0f, true);
        transformApplier.accept(quaternion);
        TRANSFORM_VECTOR.m_122251_(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.m_122251_(quaternion);
            vector3f.m_122261_(size);
            vector3f.m_122272_(x, y, z);
        }
        int light = this.m_6355_(partialTicks);
        this.makeCornerVertex(consumer, avector3f[0], this.m_5952_(), this.m_5950_(), light);
        this.makeCornerVertex(consumer, avector3f[1], this.m_5952_(), this.m_5951_(), light);
        this.makeCornerVertex(consumer, avector3f[2], this.m_5970_(), this.m_5951_(), light);
        this.makeCornerVertex(consumer, avector3f[3], this.m_5970_(), this.m_5950_(), light);
    }

    private void makeCornerVertex(VertexConsumer consumer, Vector3f pos, float u, float v, int light) {
        consumer.m_5483_((double)pos.m_122239_(), (double)pos.m_122260_(), (double)pos.m_122269_()).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.sprites);
        }
    }

    protected float m_5970_() {
        return this.reverse ? super.m_5952_() : super.m_5970_();
    }

    protected float m_5952_() {
        return this.reverse ? super.m_5970_() : super.m_5952_();
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public static class Provider
    implements ParticleProvider<SweepingStrikeParticleOption> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SweepingStrikeParticleOption option, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new SweepingStrikeParticle(level, x, y, z, this.sprites, option.duration(), option.reverse(), option.pitch(), option.yaw());
        }
    }
}

