/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.gui;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.effect.FocusEffect;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.gui.InvertColorGui;
import se.mickelus.tetra.items.modular.ModularItem;

@ParametersAreNonnullByDefault
public class FocusGui
extends GuiElement {
    private final GuiElement container;
    private final GuiTexture left;
    private final GuiTexture right;

    public FocusGui() {
        super(-1, 1, 0, 0);
        this.setAttachment(GuiAttachment.middleCenter);
        this.container = new InvertColorGui(0, 0, this.width, this.height).setOpacity(0.0f);
        this.addChild(this.container);
        this.left = new GuiTexture(-1, 0, 2, 2, 0, 1, GuiTextures.hud);
        this.left.setUseDefaultBlending(false);
        this.left.setAttachment(GuiAttachment.topRight);
        this.container.addChild((GuiElement)this.left);
        this.right = new GuiTexture(2, 0, 2, 2, 1, 1, GuiTextures.hud);
        this.right.setUseDefaultBlending(false);
        this.container.addChild((GuiElement)this.right);
    }

    public void setSpread(float progress, float cap) {
        if (progress != -1.0f) {
            int offset = (int)Mth.m_14179_((float)progress, (float)Math.min(6.0f, 3.0f + cap / 3.0f), (float)0.0f);
            this.left.setX(-1 - offset);
            this.left.setY(offset);
            this.right.setX(2 + offset);
            this.right.setY(offset);
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    public void update(Player player) {
        if (player.m_6047_() && FocusEffect.hasApplicableItem((LivingEntity)player)) {
            float spreadReduction;
            float spread = this.getSpread(player.m_21205_());
            if (spread <= -1.0f) {
                spread = this.getSpread(player.m_21206_());
                spreadReduction = FocusEffect.getSpreadReduction(player, player.m_21206_());
            } else {
                spreadReduction = FocusEffect.getSpreadReduction(player, player.m_21205_());
            }
            if (spread > 0.0f) {
                this.setSpread(Mth.m_14036_((float)(spreadReduction / (100.0f - spread)), (float)0.0f, (float)1.0f), Math.max(0.0f, 100.0f - spread));
                return;
            }
        }
        this.setSpread(-1.0f, 0.0f);
    }

    private float getSpread(ItemStack itemStack) {
        return CastOptional.cast((Object)itemStack.m_41720_(), ModularItem.class).map(item -> Float.valueOf(item.getEffectEfficiency(itemStack, ItemEffect.spread))).orElse(Float.valueOf(-1.0f)).floatValue();
    }
}

