/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiClickable;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.mutil.gui.GuiStringOutline;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.GuiAnimation;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiTextures;

@ParametersAreNonnullByDefault
public class HoloMaterialsButtonGui
extends GuiClickable {
    private final GuiTexture backdrop;
    private final GuiTexture icon;
    private final GuiString label;
    private final List<GuiAnimation> hoverAnimations = new ArrayList<GuiAnimation>();
    private final List<GuiAnimation> blurAnimations = new ArrayList<GuiAnimation>();
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation hideAnimation;

    public HoloMaterialsButtonGui(int x, int y, Runnable onClickHandler) {
        super(x, y, 64, 64, onClickHandler);
        this.backdrop = new GuiTexture(0, 0, 52, 52, GuiTextures.workbench);
        this.backdrop.setAttachment(GuiAttachment.middleCenter);
        this.addChild((GuiElement)this.backdrop);
        this.icon = new GuiTexture(0, 0, 38, 38, 0, 180, GuiTextures.workbench);
        this.icon.setAttachment(GuiAttachment.middleCenter);
        this.addChild((GuiElement)this.icon);
        this.label = new GuiStringOutline(0, -1, I18n.m_118938_((String)"tetra.holo.craft.materials", (Object[])new Object[0]));
        this.label.setAttachment(GuiAttachment.middleCenter);
        this.label.setOpacity(0.0f);
        this.addChild((GuiElement)this.label);
        this.showAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f)});
        this.hideAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f)}).onStop(complete -> {
            this.isVisible = false;
        });
        this.hoverAnimations.add((GuiAnimation)new KeyframeAnimation(80, (GuiElement)this.label).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY(-2.0f, 0.0f)}));
        this.blurAnimations.add((GuiAnimation)new KeyframeAnimation(120, (GuiElement)this.label).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY(0.0f, 2.0f)}));
    }

    protected void onFocus() {
        this.backdrop.setColor(0xFFFFCC);
        this.label.setColor(0xFFFFCC);
        this.icon.setColor(0x7F7F7F);
        this.blurAnimations.forEach(GuiAnimation::stop);
        this.hoverAnimations.forEach(GuiAnimation::start);
    }

    protected void onBlur() {
        this.backdrop.setColor(0xFFFFFF);
        this.label.setColor(0xFFFFFF);
        this.icon.setColor(0xFFFFFF);
        this.hoverAnimations.forEach(GuiAnimation::stop);
        this.blurAnimations.forEach(GuiAnimation::start);
    }

    protected void onShow() {
        super.onShow();
        this.hideAnimation.stop();
        this.showAnimation.start();
    }

    protected boolean onHide() {
        super.onHide();
        this.showAnimation.stop();
        this.hideAnimation.start();
        return false;
    }

    public void updateFocusState(int refX, int refY, int mouseX, int mouseY) {
        boolean gainFocus;
        boolean bl = gainFocus = (mouseX -= refX + this.x) + (mouseY -= refY + this.y) >= 44;
        if (mouseX + mouseY > 84) {
            gainFocus = false;
        }
        if (mouseX - mouseY > 16) {
            gainFocus = false;
        }
        if (mouseY - mouseX > 19) {
            gainFocus = false;
        }
        if (gainFocus != this.hasFocus) {
            this.hasFocus = gainFocus;
            if (this.hasFocus) {
                this.onFocus();
            } else {
                this.onBlur();
            }
        }
    }
}

