/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.properties;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.module.data.ToolData;

public interface IToolProvider {
    public static final Logger logger = LogManager.getLogger();

    public boolean canProvideTools(ItemStack var1);

    public ToolData getToolData(ItemStack var1);

    default public int getToolLevel(ItemStack itemStack, ToolAction tool) {
        if (!this.canProvideTools(itemStack)) {
            return -1;
        }
        return this.getToolData(itemStack).getLevel(tool);
    }

    default public float getToolEfficiency(ItemStack itemStack, ToolAction tool) {
        if (this.getToolLevel(itemStack, tool) <= 0) {
            return 0.0f;
        }
        return this.getToolData(itemStack).getEfficiency(tool);
    }

    default public Set<ToolAction> getTools(ItemStack itemStack) {
        if (!this.canProvideTools(itemStack)) {
            return Collections.emptySet();
        }
        return this.getToolData(itemStack).getValues();
    }

    default public Map<ToolAction, Integer> getToolLevels(ItemStack itemStack) {
        if (!this.canProvideTools(itemStack)) {
            return Collections.emptyMap();
        }
        return this.getToolData(itemStack).getLevelMap();
    }

    default public ItemStack onCraftConsume(ItemStack providerStack, ItemStack targetStack, Player player, ToolAction tool, int toolLevel, boolean consumeResources) {
        ItemStack result = targetStack.m_41777_();
        return result;
    }

    default public ItemStack onActionConsume(ItemStack providerStack, ItemStack targetStack, Player player, ToolAction tool, int toolLevel, boolean consumeResources) {
        ItemStack result = targetStack.m_41777_();
        return result;
    }
}

