/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.config.screen;

import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import terrails.healthoverlay.config.ConfigOption;
import terrails.healthoverlay.config.Configuration;
import terrails.healthoverlay.config.screen.base.AbstractPlacementScreen;
import terrails.healthoverlay.config.screen.widgets.HeartTypeToggle;
import terrails.healthoverlay.config.screen.widgets.MovableHeartBar;
import terrails.healthoverlay.utilities.Vec2i;

public class HeartBarPlacementScreen
extends AbstractPlacementScreen {
    private MovableHeartBar heartBar;
    private HeartTypeToggle typeToggle;

    public HeartBarPlacementScreen(Screen lastScreen, Component component) {
        super(lastScreen, component);
    }

    @Override
    protected void m_7856_() {
        this.typeToggle = (HeartTypeToggle)this.m_142416_((GuiEventListener)new HeartTypeToggle(10, this.f_96544_ - 18, this.isModifyingHealth(), button -> {
            this.saveValuesToConfig();
            this.typeToggle.modifyingHealth = !this.typeToggle.modifyingHealth;
            this.m_232761_();
        }));
        Vec2i root = this.getRelativeTo().rootCoordinates();
        int x = this.getCoordinateX() + root.getX();
        int y = this.getCoordinateY() + root.getY();
        this.heartBar = (MovableHeartBar)this.m_142416_((GuiEventListener)new MovableHeartBar(x, y, this.getMovableWidth(), this.getMovableHeight(), this.isModifyingHealth(), this::updateDragging, this));
        super.m_7856_();
    }

    @Override
    public int getMovableWidth() {
        return 81;
    }

    @Override
    public int getMovableHeight() {
        return 9;
    }

    @Override
    public void setMovableX(int x) {
        if (!this.isHeartBarBeingDragged()) {
            this.heartBar.f_93620_ = x;
        }
    }

    @Override
    public void setMovableY(int y) {
        if (!this.isHeartBarBeingDragged()) {
            this.heartBar.f_93621_ = y;
        }
    }

    @Override
    public ConfigOption<Configuration.RelativeTo> configRelativeTo() {
        if (this.isModifyingHealth()) {
            return Configuration.HEALTH.posRelativeTo;
        }
        return Configuration.ABSORPTION.posRelativeTo;
    }

    @Override
    public ConfigOption<Integer> configCoordinateX() {
        if (this.isModifyingHealth()) {
            return Configuration.HEALTH.posX;
        }
        return Configuration.ABSORPTION.posX;
    }

    @Override
    public ConfigOption<Integer> configCoordinateY() {
        if (this.isModifyingHealth()) {
            return Configuration.HEALTH.posY;
        }
        return Configuration.ABSORPTION.posY;
    }

    public boolean isHeartBarBeingDragged() {
        return this.m_7282_() && this.m_7222_() == this.heartBar;
    }

    public boolean isModifyingHealth() {
        return this.typeToggle == null || this.typeToggle.isModifyingHealth();
    }

    public void updateDragging(Vec2i coordinates) {
        Vec2i root = this.getRelativeTo().rootCoordinates();
        int x = coordinates.getX() - root.getX();
        int y = coordinates.getY() - root.getY();
        this.setCoordinateX(x);
        this.setCoordinateY(y);
    }
}

