/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.delogger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import com.unrealdinnerbone.delogger.DeLoggerConfig;
import com.unrealdinnerbone.delogger.LoggerFilter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.slf4j.Logger;

public class LoggerHacks {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void init() {
        Path configFile = FMLPaths.CONFIGDIR.get().resolve("delogger2.json");
        if (LoggerHacks.createFile(configFile)) {
            try {
                DeLoggerConfig config = LoggerHacks.createConfig(configFile);
                LoggerHacks.disableLogger(config);
                if (config.printWarningMessage) {
                    LOGGER.info("!!! SOME LOGGERS HAVE MOVED TO THE DEBUG FILE (Please Include them in your bug reports) !!!");
                }
            }
            catch (IOException e) {
                LOGGER.error("Error reading json from delogger.json", (Throwable)e);
            }
        }
    }

    public static DeLoggerConfig createConfig(Path path) throws IOException {
        DeLoggerConfig deLoggerConfig = (DeLoggerConfig)GSON.fromJson((Reader)Files.newBufferedReader(path), DeLoggerConfig.class);
        if (deLoggerConfig == null || deLoggerConfig.dontChangeMe == null) {
            deLoggerConfig = new DeLoggerConfig();
        }
        Files.writeString(path, (CharSequence)GSON.toJson((Object)deLoggerConfig), new OpenOption[0]);
        return deLoggerConfig;
    }

    private static boolean createFile(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
                return true;
            }
            catch (IOException e) {
                LOGGER.error("Error creating delogger.json", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static void disableLogger(DeLoggerConfig deLoggerConfig) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        LoggerFilter filter = new LoggerFilter(deLoggerConfig);
        loggerConfig.getAppenders().values().stream().peek(value -> {
            if (deLoggerConfig.printLoggerTypes) {
                LOGGER.info("Logger Type: {}", (Object)value.getName());
            }
        }).filter(value -> !deLoggerConfig.whitelistLoggersTypes.contains(value.getName()) && value instanceof AbstractFilterable).map(value -> (AbstractFilterable)value).forEach(filterable -> filterable.addFilter((Filter)filter));
    }
}

