/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createendertransmission.blocks.itemTransmitter;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ItemTransmitterInventoryHandler
extends ItemStackHandler {
    protected final Supplier<INBTSerializable<CompoundTag>> superWrapper;

    public ItemTransmitterInventoryHandler(Supplier<INBTSerializable<CompoundTag>> superWrapper) {
        this.superWrapper = superWrapper;
    }

    public ItemStackHandler superWrapper() {
        return (ItemStackHandler)this.superWrapper.get();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.superWrapper().insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.superWrapper().extractItem(slot, amount, simulate);
    }

    public int getSlots() {
        return this.superWrapper().getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.superWrapper().getStackInSlot(slot);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.superWrapper().setStackInSlot(slot, stack);
    }

    public void setSize(int size) {
        this.superWrapper().setSize(size);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.superWrapper().isItemValid(slot, stack);
    }

    public CompoundTag serializeNBT() {
        return this.superWrapper().serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.superWrapper().deserializeNBT(nbt);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.superWrapper().getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }
}

