/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.cards;

import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.setup.ModSetup;
import com.direwolf20.laserio.util.MiscTools;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BaseCard
extends Item {
    protected CardType CARDTYPE;

    public BaseCard() {
        super(new Item.Properties().m_41491_(ModSetup.ITEM_GROUP).m_41487_(1));
    }

    public CardType getCardType() {
        return this.CARDTYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        Minecraft mc = Minecraft.m_91087_();
        if (world == null || mc.f_91074_ == null) {
            return;
        }
        boolean sneakPressed = Screen.m_96638_();
        if (!sneakPressed) {
            tooltip.add((Component)Component.m_237115_((String)"laserio.tooltip.item.show_settings").m_130940_(ChatFormatting.GRAY));
        } else {
            String currentMode = BaseCard.getNamedTransferMode(stack).toString();
            MutableComponent toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.mode", ChatFormatting.GRAY.m_126665_());
            int modeColor = ChatFormatting.GRAY.m_126665_();
            if (currentMode.equals("EXTRACT")) {
                modeColor = ChatFormatting.RED.m_126665_();
            } else if (currentMode.equals("INSERT")) {
                modeColor = ChatFormatting.GREEN.m_126665_();
            } else if (currentMode.equals("STOCK")) {
                modeColor = ChatFormatting.BLUE.m_126665_();
            } else if (currentMode.equals("SENSOR")) {
                modeColor = ChatFormatting.YELLOW.m_126665_();
            }
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.mode." + currentMode, modeColor));
            tooltip.add((Component)toWrite);
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.channel", ChatFormatting.GRAY.m_126665_());
            byte channel = BaseCard.getChannel(stack);
            toWrite.m_7220_((Component)MiscTools.tooltipMaker(String.valueOf(channel), LaserNodeBERender.colors[channel].getRGB()));
            tooltip.add((Component)toWrite);
            byte sneakyMode = BaseCard.getSneaky(stack);
            if (sneakyMode != -1) {
                toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.sneaky", ChatFormatting.GRAY.m_126665_());
                toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.sneaky." + Direction.values()[sneakyMode].toString().toUpperCase(Locale.ROOT), ChatFormatting.DARK_GREEN.m_126665_()));
                tooltip.add((Component)toWrite);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public NonNullList<ItemStack> getContainerItems(ItemStack itemStack) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        nonnulllist.set(0, (Object)BaseCard.getInventory(itemStack).getStackInSlot(0));
        nonnulllist.set(1, (Object)BaseCard.getInventory(itemStack).getStackInSlot(1));
        return nonnulllist;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return !BaseCard.getInventory(stack).getStackInSlot(0).equals(ItemStack.f_41583_) || !BaseCard.getInventory(stack).getStackInSlot(1).equals(ItemStack.f_41583_);
    }

    public static CardItemHandler getInventory(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_("inv")) {
            return new CardItemHandler(2, stack);
        }
        CardItemHandler handler = new CardItemHandler(2, stack);
        handler.deserializeNBT(compound.m_128469_("inv"));
        if (handler.getSlots() < 2) {
            handler.reSize(2);
        }
        return handler;
    }

    public static CardItemHandler setInventory(ItemStack stack, CardItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            stack.m_41784_().m_128365_("inv", (Tag)handler.serializeNBT());
            return handler;
        }
        stack.m_41749_("inv");
        return handler;
    }

    public static byte setTransferMode(ItemStack card, byte mode) {
        if (mode == 0) {
            card.m_41749_("mode");
        } else {
            card.m_41784_().m_128344_("mode", mode);
        }
        return mode;
    }

    public static byte getTransferMode(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("mode")) {
            return 0;
        }
        return compound.m_128445_("mode");
    }

    public static byte nextTransferMode(ItemStack card) {
        byte mode = BaseCard.getTransferMode(card);
        return BaseCard.setTransferMode(card, (byte)(mode == 3 ? 0 : mode + 1));
    }

    public static TransferMode getNamedTransferMode(ItemStack card) {
        return TransferMode.values()[BaseCard.getTransferMode(card)];
    }

    public static byte setChannel(ItemStack card, byte channel) {
        if (channel == 0) {
            card.m_41749_("channel");
        } else {
            card.m_41784_().m_128344_("channel", channel);
        }
        return channel;
    }

    public static byte getChannel(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("channel")) {
            return 0;
        }
        return compound.m_128445_("channel");
    }

    public static byte nextChannel(ItemStack card) {
        byte k = BaseCard.getChannel(card);
        return BaseCard.setChannel(card, (byte)(k == 15 ? 0 : k + 1));
    }

    public static byte previousChannel(ItemStack card) {
        byte k = BaseCard.getChannel(card);
        return BaseCard.setChannel(card, (byte)(k == 0 ? 15 : k - 1));
    }

    public static int setExtractSpeed(ItemStack card, int itemextractspeed) {
        if (itemextractspeed == 20) {
            card.m_41749_("itemextractspeed");
        } else {
            card.m_41784_().m_128405_("itemextractspeed", itemextractspeed);
        }
        return itemextractspeed;
    }

    public static int getExtractSpeed(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("itemextractspeed")) {
            return 20;
        }
        return compound.m_128451_("itemextractspeed");
    }

    public static short setPriority(ItemStack card, short priority) {
        if (priority == 0) {
            card.m_41749_("priority");
        } else {
            card.m_41784_().m_128376_("priority", priority);
        }
        return priority;
    }

    public static short getPriority(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("priority")) {
            return 0;
        }
        return compound.m_128448_("priority");
    }

    public static ItemStack getFilter(ItemStack card) {
        CardItemHandler cardItemHandler = BaseCard.getInventory(card);
        return cardItemHandler.getStackInSlot(0);
    }

    public static byte setSneaky(ItemStack card, byte sneaky) {
        if (sneaky == -1) {
            card.m_41749_("sneaky");
        } else {
            card.m_41784_().m_128344_("sneaky", sneaky);
        }
        return sneaky;
    }

    public static byte getSneaky(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("sneaky")) {
            return -1;
        }
        return compound.m_128445_("sneaky");
    }

    public static byte nextSneaky(ItemStack card) {
        byte k = BaseCard.getSneaky(card);
        return BaseCard.setSneaky(card, (byte)(k == 5 ? -1 : k + 1));
    }

    public static byte previousSneaky(ItemStack card) {
        byte k = BaseCard.getSneaky(card);
        return BaseCard.setSneaky(card, (byte)(k == -1 ? 5 : k - 1));
    }

    public static boolean getRegulate(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_("regulate")) {
            return false;
        }
        return compound.m_128471_("regulate");
    }

    public static boolean setRegulate(ItemStack stack, boolean regulate) {
        if (!regulate) {
            stack.m_41749_("regulate");
        } else {
            stack.m_41784_().m_128379_("regulate", regulate);
        }
        return regulate;
    }

    public static int getRoundRobin(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_("roundRobin")) {
            return 0;
        }
        return compound.m_128451_("roundRobin");
    }

    public static int setRoundRobin(ItemStack stack, int roundRobin) {
        if (roundRobin == 0) {
            stack.m_41749_("roundRobin");
        } else {
            stack.m_41784_().m_128405_("roundRobin", roundRobin);
        }
        return roundRobin;
    }

    public static byte getRedstoneMode(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_("redstoneMode")) {
            return 0;
        }
        return compound.m_128445_("redstoneMode");
    }

    public static byte setRedstoneMode(ItemStack stack, byte redstoneMode) {
        if (redstoneMode == 0) {
            stack.m_41749_("redstoneMode");
        } else {
            stack.m_41784_().m_128344_("redstoneMode", redstoneMode);
        }
        return redstoneMode;
    }

    public static byte nextRedstoneMode(ItemStack card) {
        byte mode = BaseCard.getRedstoneMode(card);
        return BaseCard.setRedstoneMode(card, (byte)(mode == 2 ? 0 : mode + 1));
    }

    public static boolean getExact(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_("exact")) {
            return false;
        }
        return compound.m_128471_("exact");
    }

    public static boolean setExact(ItemStack stack, boolean exact) {
        if (!exact) {
            stack.m_41749_("exact");
        } else {
            stack.m_41784_().m_128379_("exact", exact);
        }
        return exact;
    }

    public static byte setRedstoneChannel(ItemStack card, byte redstonechannel) {
        if (redstonechannel == 0) {
            card.m_41749_("redstonechannel");
        } else {
            card.m_41784_().m_128344_("redstonechannel", redstonechannel);
        }
        return redstonechannel;
    }

    public static byte getRedstoneChannel(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("redstonechannel")) {
            return 0;
        }
        return compound.m_128445_("redstonechannel");
    }

    public static byte nextRedstoneChannel(ItemStack card) {
        byte k = BaseCard.getRedstoneChannel(card);
        return BaseCard.setRedstoneChannel(card, (byte)(k == 15 ? 0 : k + 1));
    }

    public static byte previousRedstoneChannel(ItemStack card) {
        byte k = BaseCard.getRedstoneChannel(card);
        return BaseCard.setRedstoneChannel(card, (byte)(k == 0 ? 15 : k - 1));
    }

    public static boolean getAnd(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_("and")) {
            return false;
        }
        return compound.m_128471_("and");
    }

    public static boolean setAnd(ItemStack stack, boolean and) {
        if (!and) {
            stack.m_41749_("and");
        } else {
            stack.m_41784_().m_128379_("and", and);
        }
        return and;
    }

    public static enum CardType {
        ITEM,
        FLUID,
        ENERGY,
        REDSTONE,
        MISSING;

    }

    public static enum TransferMode {
        INSERT,
        EXTRACT,
        STOCK,
        SENSOR;

    }
}

