/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.item;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.client.EnderPouchBakery;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.generation.IBakery;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemEnderPouch
extends Item
implements IBakeryProvider {
    public ItemEnderPouch() {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40752_));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Frequency frequency = Frequency.readFromStack(stack);
        if (frequency.hasOwner()) {
            tooltip.add(frequency.getOwnerName());
        }
        tooltip.add(frequency.getTooltip());
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level world = context.m_43725_();
        if (world.m_5776_()) {
            return InteractionResult.PASS;
        }
        BlockEntity tile = world.m_7702_(context.m_8083_());
        if (tile instanceof TileEnderChest) {
            TileEnderChest chest = (TileEnderChest)tile;
            if (context.m_43723_().m_6047_()) {
                Frequency frequency = chest.getFrequency().copy();
                if (EnderStorageConfig.anarchyMode && (frequency.owner == null || !frequency.owner.equals(context.m_43723_().m_20148_()))) {
                    frequency.clearOwner();
                }
                frequency.writeToStack(stack);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (!world.f_46443_) {
            Frequency frequency = Frequency.readFromStack(stack);
            EnderStorageManager.instance(world.f_46443_).getStorage(frequency, EnderItemStorage.TYPE).openContainer((ServerPlayer)player, (Component)Component.m_237115_((String)stack.m_41778_()));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBakery getBakery() {
        return EnderPouchBakery.INSTANCE;
    }
}

