/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.items;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.storage.IStorageModuleItem;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.storage.StorageInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;

public class StorageModuleItem
extends Item
implements INBTPreservingIngredient,
IStorageModuleItem {
    public static final int STORAGE_TIER1 = 0;
    public static final int STORAGE_TIER2 = 1;
    public static final int STORAGE_TIER3 = 2;
    public static final int STORAGE_TIER4 = 3;
    public static final int STORAGE_REMOTE = 6;
    public static final int[] MAXSIZE = new int[]{100, 200, 300, 500, 0, 0, -1};
    private final int tier;
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"items", stack -> !this.isRemoteModule() && this.hasUUID((ItemStack)stack), this::getContentsStringClient), TooltipBuilder.key((String)"message.rftoolsstorage.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(stack -> this.isRemoteModule()), TooltipBuilder.parameter((String)"info", stack -> !this.isRemoteModule(), stack -> Integer.toString(this.getMax())), TooltipBuilder.parameter((String)"remoteid", stack -> this.isRemoteModule(), stack -> {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("id")) {
            int id = tag.m_128451_("id");
            return Integer.toString(id);
        }
        return "<unlinked>";
    }), TooltipBuilder.parameter((String)"uuid", stack -> {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_("uuid")) {
            return tag.m_128342_("uuid").toString();
        }
        return "<unset>";
    }), TooltipBuilder.parameter((String)"version", stack -> {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return Integer.toString(tag.m_128451_("version"));
        }
        return "<unset>";
    }), TooltipBuilder.parameter((String)"items", stack -> !this.isRemoteModule() && this.hasUUID((ItemStack)stack), this::getContentsStringClient)}).infoAdvanced(new InfoLine[]{TooltipBuilder.parameter((String)"advanced", this::getAdvancedInfoClient)});

    private String getContentsStringClient(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("infoAmount")) {
            int cnt = stack.m_41783_().m_128451_("infoAmount");
            return cnt + "/" + this.getMax();
        }
        return "<unknown>";
    }

    private String getAdvancedInfoClient(ItemStack stack) {
        StorageInfo storage = this.getStorageClient(stack);
        if (storage != null) {
            String createdBy = storage.createdBy();
            Object info = "";
            info = createdBy != null && !createdBy.isEmpty() ? (String)info + "Created by " + createdBy : (String)info + "Unknown creator";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date creationTime = new Date(stack.m_41783_().m_128454_("infoCreateTime"));
            Date updateTime = new Date(stack.m_41783_().m_128454_("infoUpdateTime"));
            info = (String)info + ", Creation time " + dateFormat.format(creationTime);
            info = (String)info + ", Update time " + dateFormat.format(updateTime);
            return info;
        }
        return "<unknown>";
    }

    private StorageInfo getStorageClient(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        return StorageModuleItem.getStorageInfo(stack);
    }

    @Nonnull
    public static StorageInfo getStorageInfo(ItemStack storageCard) {
        Item item = storageCard.m_41720_();
        if (item instanceof StorageModuleItem) {
            UUID uuid = StorageModuleItem.getOrCreateUUID(storageCard);
            int version = StorageModuleItem.getVersion(storageCard);
            int size = StorageModuleItem.getSize(storageCard);
            String createdBy = StorageModuleItem.getCreatedBy(storageCard);
            return new StorageInfo(uuid, version, size, createdBy);
        }
        return StorageInfo.EMPTY;
    }

    private boolean isRemoteModule() {
        return this.getMax() == -1;
    }

    private boolean hasUUID(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41783_().m_128403_("uuid");
    }

    public StorageModuleItem(int tier) {
        super(RFToolsStorage.setup.defaultProperties().m_41487_(1).m_41503_(0));
        this.tier = tier;
    }

    private int getMax() {
        return MAXSIZE[this.tier];
    }

    public void m_7836_(@Nonnull ItemStack stack, @Nonnull Level worldIn, @Nonnull Player player) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("createdBy")) {
            tag.m_128359_("createdBy", player.m_7755_().getString());
        }
    }

    public static UUID getOrCreateUUID(ItemStack stack) {
        if (!(stack.m_41720_() instanceof StorageModuleItem)) {
            throw new RuntimeException("This is not supposed to happen! Needs to be a storage item!");
        }
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128403_("uuid")) {
            nbt.m_128362_("uuid", UUID.randomUUID());
            nbt.m_128405_("version", 0);
        }
        return nbt.m_128342_("uuid");
    }

    public static String getCreatedBy(ItemStack storageCard) {
        if (storageCard.m_41782_()) {
            return storageCard.m_41783_().m_128461_("createdBy");
        }
        return null;
    }

    public static int getVersion(ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128451_("version");
        }
        return 0;
    }

    public static int getSize(ItemStack storageCard) {
        if (storageCard.m_41720_() instanceof StorageModuleItem) {
            int tier = ((StorageModuleItem)storageCard.m_41720_()).tier;
            return MAXSIZE[tier];
        }
        return 0;
    }

    public Collection<String> getTagsToPreserve() {
        return List.of("uuid");
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Place this module in a storage module tablet to access contents"));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void m_7373_(@Nonnull ItemStack itemStack, @Nullable Level worldIn, @Nonnull List<Component> list, @Nonnull TooltipFlag flags) {
        super.m_7373_(itemStack, worldIn, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(new ResourceLocation("rftoolsstorage", "storage_module"), itemStack, list, flags);
    }
}

