/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.state;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;

@ParametersAreNonnullByDefault
public class CTMContext {
    private final BlockGetter world;
    private final BlockPos pos;
    @Nullable
    private RenderContextList ctxCache;

    public CTMContext(BlockGetter world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public CTMContext(CTMContext parent) {
        this(parent.world, parent.pos);
    }

    public RenderContextList getContextList(BlockState state, AbstractCTMBakedModel model) {
        if (this.ctxCache == null) {
            this.ctxCache = new RenderContextList(state, model.getCTMTextures(), this.world, this.pos);
        }
        return this.ctxCache;
    }

    public BlockGetter getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

