/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui;

import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.localization.LocalizationEntry;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.util.SFMHandUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.jetbrains.annotations.Nullable;

public class LabelGunReminderOverlay
implements IGuiOverlay {
    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        LocalizationEntry msg;
        Minecraft minecraft = gui.getMinecraft();
        if (minecraft.f_91066_.f_92062_) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        LabelGunItem.LabelGunViewMode viewMode = LabelGunReminderOverlay.getViewMode(minecraft);
        if (viewMode == null) {
            return;
        }
        switch (viewMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SHOW_ALL: {
                LocalizationEntry localizationEntry = null;
                break;
            }
            case SHOW_ONLY_ACTIVE_LABEL_AND_TARGETED_BLOCK: {
                LocalizationEntry localizationEntry = LocalizationKeys.LABEL_GUN_VIEW_MODE_SHOW_ONLY_ACTIVE_AND_TARGETED;
                break;
            }
            case SHOW_ONLY_TARGETED_BLOCK: {
                LocalizationEntry localizationEntry = msg = LocalizationKeys.LABEL_GUN_VIEW_MODE_SHOW_ONLY_TARGETED;
            }
        }
        if (msg == null) {
            return;
        }
        Font font = minecraft.f_91062_;
        MutableComponent reminder = msg.getComponent(((KeyMapping)SFMKeyMappings.CYCLE_LABEL_VIEW_KEY.get()).m_90863_().m_6879_().m_130940_(ChatFormatting.YELLOW));
        int reminderWidth = font.m_92852_((FormattedText)reminder);
        int x = screenWidth / 2 - reminderWidth / 2;
        int y = 20;
        font.m_92763_(poseStack, (Component)reminder, (float)x, (float)y, FastColor.ARGB32.m_13660_((int)255, (int)172, (int)208, (int)255));
    }

    @Nullable
    private static LabelGunItem.LabelGunViewMode getViewMode(Minecraft minecraft) {
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return null;
        }
        if (!((Boolean)SFMConfig.CLIENT.showLabelGunReminderOverlay.get()).booleanValue()) {
            return null;
        }
        ItemStack labelGun = SFMHandUtils.getItemInEitherHand((Player)player, (Item)SFMItems.LABEL_GUN_ITEM.get());
        if (labelGun.m_41619_()) {
            return null;
        }
        return LabelGunItem.getViewMode(labelGun);
    }
}

