/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.block.WaterTankBlock;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.watertanknetwork.WaterNetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterTankBlockEntity
extends BlockEntity {
    public final FluidTank TANK = new FluidTank(1000, fluidStack -> false){

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.getFluidAmount() == 0) {
                return FluidStack.EMPTY;
            }
            int drained = Math.min(maxDrain, this.getFluidAmount());
            FluidStack copy = this.getFluid().copy();
            copy.setAmount(drained);
            return copy;
        }
    };
    public final LazyOptional<IFluidHandler> TANK_CAPABILITY = LazyOptional.of(() -> this.TANK);
    private boolean active = false;

    public WaterTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SFMBlockEntities.WATER_TANK_BLOCK_ENTITY.get(), pos, state);
        this.setActive(state.m_61145_((Property)WaterTankBlock.IN_WATER).orElse(false));
    }

    public void setConnectedCount(int connectedCount) {
        int newCapacity = (int)Math.pow(2.0, connectedCount - 1) * 1000;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        this.TANK.setCapacity(newCapacity);
        this.updateTank();
    }

    public void setActive(boolean active) {
        this.active = active;
        this.updateTank();
    }

    public void onLoad() {
        super.onLoad();
        WaterNetworkManager.onLoad(this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.TANK_CAPABILITY.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.TANK_CAPABILITY.invalidate();
    }

    private void updateTank() {
        if (this.active) {
            this.TANK.setFluid(new FluidStack((Fluid)Fluids.f_76193_, this.TANK.getCapacity()));
        } else {
            this.TANK.setFluid(FluidStack.EMPTY);
        }
    }
}

