/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class RegexCache {
    private static final Map<String, Predicate<String>> patternCache = new Object2ObjectOpenHashMap();

    public static Predicate<String> buildPredicate(String possiblePattern) {
        return RegexCache.isRegexPattern(possiblePattern) ? patternCache.computeIfAbsent(possiblePattern, RegexCache::getPredicateFromRegex) : possiblePattern::equalsIgnoreCase;
    }

    private static Predicate<String> getPredicateFromRegex(String x) {
        String[] parts;
        if (x.startsWith(".*") && x.endsWith(".*")) {
            String substring = x.substring(2, x.length() - 2);
            if (!RegexCache.isRegexPattern(substring)) {
                return s -> s.contains(substring);
            }
        } else if (x.startsWith(".*")) {
            String suffix = x.substring(2);
            if (!RegexCache.isRegexPattern(suffix)) {
                return s -> s.endsWith(suffix);
            }
        } else if (x.endsWith(".*")) {
            String prefix = x.substring(0, x.length() - 2);
            if (!RegexCache.isRegexPattern(prefix)) {
                return s -> s.startsWith(prefix);
            }
        } else if (x.contains(".*") && (parts = x.split("\\.\\*")).length == 2 && !RegexCache.isRegexPattern(parts[0]) && !RegexCache.isRegexPattern(parts[1])) {
            return s -> s.startsWith(parts[0]) && s.endsWith(parts[1]);
        }
        return Pattern.compile(x).asMatchPredicate();
    }

    public static boolean isRegexPattern(String pattern) {
        String specialChars = ".?*+^$[](){}|\\";
        for (int i = 0; i < pattern.length(); ++i) {
            if (specialChars.indexOf(pattern.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    static {
        String[] matchAny = new String[]{".", "[a-z0-9/._-]"};
        String[] suffixes = new String[]{"+", "*"};
        for (String s : matchAny) {
            for (String suffix : suffixes) {
                patternCache.put(s + suffix, s1 -> true);
                patternCache.put("^" + s + suffix, s1 -> true);
                patternCache.put("^" + s + suffix + "$", s1 -> true);
                patternCache.put(s + suffix + "$", s1 -> true);
            }
        }
    }
}

