/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.BoolExpr;
import ca.teamdman.sfml.ast.ComparisonOperator;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.SetOperator;
import ca.teamdman.sfml.ast.With;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPos;

public record BoolHas(SetOperator setOperator, LabelAccess labelAccess, ComparisonOperator comparisonOperator, long quantity, ResourceIdSet resourceIdSet, With with, ResourceIdSet except) implements BoolExpr
{
    @Override
    public boolean test(ProgramContext programContext) {
        AtomicLong overallCount = new AtomicLong(0L);
        ArrayList<Boolean> satisfactionResults = new ArrayList<Boolean>();
        LabelPositionHolder labelPositionHolder = programContext.getLabelPositionHolder();
        ArrayList<Pair<Label, BlockPos>> labelledPositions = this.labelAccess.getLabelledPositions(labelPositionHolder);
        for (Pair<Label, BlockPos> entry : labelledPositions) {
            BlockPos pos = (BlockPos)entry.getSecond();
            AtomicLong inThisInv = new AtomicLong(0L);
            for (ResourceType<?, ?, ?> resourceType : this.resourceIdSet.getReferencedResourceTypes()) {
                this.accumulate(programContext, pos, overallCount, inThisInv, resourceType);
            }
            satisfactionResults.add(this.comparisonOperator.test(inThisInv.get(), this.quantity));
        }
        boolean isOverallSatisfied = this.comparisonOperator.test(overallCount.get(), this.quantity);
        return this.setOperator.test(isOverallSatisfied, (List<Boolean>)satisfactionResults);
    }

    @Override
    public String toString() {
        return this.setOperator + " " + this.labelAccess + " HAS " + this.comparisonOperator + " " + this.quantity + " " + this.resourceIdSet.toStringCondensed() + (String)(this.with == With.ALWAYS_TRUE ? "" : " " + this.with.toStringPretty()) + (String)(this.except.isEmpty() ? "" : " EXCEPT " + this.except.toStringCondensed());
    }

    private <STACK, ITEM, CAP> void accumulate(ProgramContext programContext, BlockPos pos, AtomicLong overallAccumulator, AtomicLong invAccumulator, ResourceType<STACK, ITEM, CAP> resourceType) {
        resourceType.forEachDirectionalCapability(programContext, this.labelAccess.directions(), pos, (direction, cap) -> resourceType.getStacksInSlots(cap, this.labelAccess.slots()).forEach(stack -> {
            if (this.resourceIdSet.getMatchingFromStack(stack) != null && this.with.matchesStack(resourceType, stack)) {
                long amount = resourceType.getAmount(stack);
                invAccumulator.addAndGet(amount);
                overallAccumulator.addAndGet(amount);
            }
        }));
    }
}

